/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.CoreSamlMetadataProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.DefaultSamlIdPCasEventListener;
import org.apereo.cas.support.saml.idp.SamlIdPCasEventListener;
import org.apereo.cas.support.saml.idp.metadata.SamlIdPMetadataResolver;
import org.apereo.cas.support.saml.idp.metadata.generator.FileSystemSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.locator.FileSystemSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.writer.DefaultSamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.idp.metadata.writer.SamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataHealthIndicator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.CachedMetadataResolverResult;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceDefaultCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.ClasspathResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.FileSystemResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.GroovyResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.JsonResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.MetadataQueryProtocolMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.UrlResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.DefaultSamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlanConfigurer;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.util.NonInflatingSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.metadata.SamlIdPMetadataController;
import org.apereo.cas.support.saml.web.idp.metadata.SamlRegisteredServiceCachedMetadataEndpoint;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPPostProfileHandlerEndpoint;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPErrorController;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAMLIdentityProvider})
@Configuration(value="SamlIdPMetadataConfiguration", proxyBeanMethods=false)
class SamlIdPMetadataConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataConfiguration.class);

    SamlIdPMetadataConfiguration() {
    }

    @Configuration(value="SamlIdPMetadataInitializationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPMetadataInitializationConfiguration {
        SamlIdPMetadataInitializationConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        @ConditionalOnMissingBean(name={"samlIdPCasEventListener"})
        public SamlIdPCasEventListener samlIdPCasEventListener(@Qualifier(value="samlIdPMetadataGenerator") SamlIdPMetadataGenerator samlIdPMetadataGenerator) {
            return new DefaultSamlIdPCasEventListener(samlIdPMetadataGenerator);
        }
    }

    @Configuration(value="SamlIdPMetadataContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPMetadataContextConfiguration {
        SamlIdPMetadataContextConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPMetadataGeneratorConfigurationContext"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, @Qualifier(value="samlSelfSignedCertificateWriter") SamlIdPCertificateAndKeyWriter samlSelfSignedCertificateWriter, @Qualifier(value="samlIdPMetadataGeneratorCipherExecutor") CipherExecutor samlIdPMetadataGeneratorCipherExecutor, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="velocityEngineFactoryBean") VelocityEngine velocityEngineFactoryBean) throws Exception {
            return SamlIdPMetadataGeneratorConfigurationContext.builder().samlIdPMetadataLocator(samlIdPMetadataLocator).samlIdPCertificateAndKeyWriter(samlSelfSignedCertificateWriter).applicationContext(applicationContext).metadataCipherExecutor(samlIdPMetadataGeneratorCipherExecutor).casProperties(casProperties).openSamlConfigBean(openSamlConfigBean).velocityEngine(velocityEngineFactoryBean).build();
        }
    }

    @Configuration(value="SamlIdPMetadataResolverConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPMetadataResolverConfiguration {
        SamlIdPMetadataResolverConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultSamlRegisteredServiceCachingMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="chainingMetadataResolverCacheLoader") CacheLoader<SamlRegisteredServiceCacheKey, CachedMetadataResolverResult> chainingMetadataResolverCacheLoader, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlRegisteredServiceDefaultCachingMetadataResolver(casProperties, chainingMetadataResolverCacheLoader, openSamlConfigBean);
        }
    }

    @Configuration(value="SamlIdPMetadataCacheConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPMetadataCacheConfiguration {
        SamlIdPMetadataCacheConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlIdPMetadataCache"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache(CasConfigurationProperties casProperties) {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            return Caffeine.newBuilder().initialCapacity(10).maximumSize(100L).expireAfterAccess(Beans.newDuration((String)idp.getMetadata().getCore().getCacheExpiration())).build();
        }

        @ConditionalOnMissingBean(name={"chainingMetadataResolverCacheLoader"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CacheLoader<SamlRegisteredServiceCacheKey, CachedMetadataResolverResult> chainingMetadataResolverCacheLoader(@Qualifier(value="samlRegisteredServiceMetadataResolvers") SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers, @Qualifier(value="httpClient") HttpClient httpClient, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlRegisteredServiceMetadataResolverCacheLoader(openSamlConfigBean, httpClient, samlRegisteredServiceMetadataResolvers);
        }
    }

    @Configuration(value="SamlIdPMetadataLocatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPMetadataLocatorConfiguration {
        SamlIdPMetadataLocatorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlIdPMetadataLocator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataLocator samlIdPMetadataLocator(ConfigurableApplicationContext applicationContext, @Qualifier(value="samlIdPMetadataGeneratorCipherExecutor") CipherExecutor samlIdPMetadataGeneratorCipherExecutor, CasConfigurationProperties casProperties, @Qualifier(value="samlIdPMetadataCache") Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache) throws Exception {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            String location = SpringExpressionLanguageValueResolver.getInstance().resolve(idp.getMetadata().getFileSystem().getLocation());
            AbstractResource metadataLocation = ResourceUtils.getRawResourceFrom((String)location);
            return new FileSystemSamlIdPMetadataLocator(samlIdPMetadataGeneratorCipherExecutor, (Resource)metadataLocation, samlIdPMetadataCache, applicationContext);
        }
    }

    @Configuration(value="SamlIdPMetadataGenerationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Lazy(value=false)
    static class SamlIdPMetadataGenerationConfiguration {
        SamlIdPMetadataGenerationConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlIdPMetadataGenerator"})
        @Bean(initMethod="initialize")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataGenerator samlIdPMetadataGenerator(@Qualifier(value="samlIdPMetadataGeneratorConfigurationContext") SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext) throws Exception {
            return new FileSystemSamlIdPMetadataGenerator(samlIdPMetadataGeneratorConfigurationContext);
        }

        @ConditionalOnMissingBean(name={"samlSelfSignedCertificateWriter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPCertificateAndKeyWriter samlSelfSignedCertificateWriter(CasConfigurationProperties casProperties) throws Exception {
            CoreSamlMetadataProperties properties = casProperties.getAuthn().getSamlIdp().getMetadata().getCore();
            URI url = new URI(casProperties.getServer().getPrefix());
            DefaultSamlIdPCertificateAndKeyWriter generator = new DefaultSamlIdPCertificateAndKeyWriter(url.getHost());
            generator.setUriSubjectAltNames(CollectionUtils.wrap((Object)url.getHost().concat("/idp/metadata")));
            properties.setCertificateAlgorithm(properties.getCertificateAlgorithm());
            properties.setKeySize(properties.getKeySize());
            return generator;
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPMetadataGeneratorCipherExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor samlIdPMetadataGeneratorCipherExecutor() {
            return CipherExecutor.noOpOfStringToString();
        }
    }

    @Configuration(value="SamlIdPMetadataResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPMetadataResolutionConfiguration {
        SamlIdPMetadataResolutionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataResolvers"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers(ObjectProvider<List<SamlRegisteredServiceMetadataResolutionPlanConfigurer>> configurersList) {
            DefaultSamlRegisteredServiceMetadataResolutionPlan plan = new DefaultSamlRegisteredServiceMetadataResolutionPlan();
            List configurers = Optional.ofNullable((List)configurersList.getIfAvailable()).orElseGet(ArrayList::new);
            configurers.forEach(cfg -> {
                LOGGER.trace("Configuring saml metadata resolution plan [{}]", (Object)cfg.getName());
                cfg.configureMetadataResolutionPlan((SamlRegisteredServiceMetadataResolutionPlan)plan);
            });
            return plan;
        }

        @Lazy
        @Bean(initMethod="initialize", destroyMethod="destroy")
        @DependsOn(value={"samlIdPMetadataGenerator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MetadataResolver casSamlIdPMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, @Qualifier(value="samlIdPMetadataGenerator") SamlIdPMetadataGenerator samlIdPMetadataGenerator, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            SamlIdPMetadataResolver resolver = new SamlIdPMetadataResolver(samlIdPMetadataLocator, samlIdPMetadataGenerator, openSamlConfigBean, casProperties);
            resolver.setFailFastInitialization(idp.getMetadata().getCore().isFailFast());
            resolver.setRequireValidMetadata(idp.getMetadata().getCore().isRequireValidMetadata());
            resolver.setId(idp.getCore().getEntityId());
            return resolver;
        }
    }

    @Configuration(value="SamlIdPDefaultMetadataResolversConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPDefaultMetadataResolversConfiguration {
        SamlIdPDefaultMetadataResolversConfiguration() {
        }

        @ConditionalOnMissingBean(name={"metadataQueryProtocolMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Order(value=-2147483648)
        public SamlRegisteredServiceMetadataResolver metadataQueryProtocolMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="httpClient") HttpClient httpClient) {
            return new MetadataQueryProtocolMetadataResolver(httpClient, casProperties.getAuthn().getSamlIdp(), openSamlConfigBean);
        }

        @ConditionalOnMissingBean(name={"jsonResourceMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Order(value=-2147483647)
        public SamlRegisteredServiceMetadataResolver jsonResourceMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new JsonResourceMetadataResolver(casProperties.getAuthn().getSamlIdp(), openSamlConfigBean);
        }

        @ConditionalOnMissingBean(name={"fileSystemResourceMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Order(value=-2147483646)
        public SamlRegisteredServiceMetadataResolver fileSystemResourceMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new FileSystemResourceMetadataResolver(casProperties.getAuthn().getSamlIdp(), openSamlConfigBean);
        }

        @ConditionalOnMissingBean(name={"urlResourceMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Order(value=-2147483645)
        public SamlRegisteredServiceMetadataResolver urlResourceMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="httpClient") HttpClient httpClient) {
            return new UrlResourceMetadataResolver(httpClient, casProperties.getAuthn().getSamlIdp(), openSamlConfigBean);
        }

        @ConditionalOnMissingBean(name={"classpathResourceMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Order(value=-2147483644)
        public SamlRegisteredServiceMetadataResolver classpathResourceMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new ClasspathResourceMetadataResolver(casProperties.getAuthn().getSamlIdp(), openSamlConfigBean);
        }

        @ConditionalOnMissingBean(name={"groovyResourceMetadataResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Order(value=-2147483643)
        @ConditionalOnMissingGraalVMNativeImage
        public SamlRegisteredServiceMetadataResolver groovyResourceMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new GroovyResourceMetadataResolver(casProperties.getAuthn().getSamlIdp(), openSamlConfigBean);
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultSamlRegisteredServiceMetadataResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlRegisteredServiceMetadataResolutionPlanConfigurer defaultSamlRegisteredServiceMetadataResolutionPlanConfigurer(List<SamlRegisteredServiceMetadataResolver> configurersList) {
            return plan -> configurersList.forEach(arg_0 -> ((SamlRegisteredServiceMetadataResolutionPlan)plan).registerMetadataResolver(arg_0));
        }
    }

    @Configuration(value="SamlIdPMetadataEndpointConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPMetadataEndpointConfiguration {
        SamlIdPMetadataEndpointConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPErrorController samlIdPErrorController() {
            return new SamlIdPErrorController();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataController samlIdPMetadataController(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="samlIdPMetadataGenerator") SamlIdPMetadataGenerator samlIdPMetadataGenerator, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, @Qualifier(value="servicesManager") ServicesManager servicesManager) throws Exception {
            return new SamlIdPMetadataController(samlIdPMetadataGenerator, samlIdPMetadataLocator, servicesManager, webApplicationServiceFactory);
        }

        @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataHealthIndicator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnEnabledHealthIndicator(value="samlRegisteredServiceMetadataHealthIndicator")
        public HealthIndicator samlRegisteredServiceMetadataHealthIndicator(@Qualifier(value="samlRegisteredServiceMetadataResolvers") SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new SamlRegisteredServiceMetadataHealthIndicator(samlRegisteredServiceMetadataResolvers, servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public SamlRegisteredServiceCachedMetadataEndpoint samlRegisteredServiceCachedMetadataEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") ObjectProvider<SamlRegisteredServiceCachingMetadataResolver> defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, @Qualifier(value="shibboleth.OpenSAMLConfig") ObjectProvider<OpenSamlConfigBean> openSamlConfigBean, @Qualifier(value="registeredServiceAccessStrategyEnforcer") ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer) {
            return new SamlRegisteredServiceCachedMetadataEndpoint(casProperties, defaultSamlRegisteredServiceCachingMetadataResolver, servicesManager, registeredServiceAccessStrategyEnforcer, openSamlConfigBean);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public SSOSamlIdPPostProfileHandlerEndpoint ssoSamlPostProfileHandlerEndpoint(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, CasConfigurationProperties casProperties, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<Response> samlProfileSamlResponseBuilder, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory) {
            return new SSOSamlIdPPostProfileHandlerEndpoint(casProperties, applicationContext, servicesManager, authenticationSystemSupport, samlIdPServiceFactory, PrincipalFactoryUtils.newPrincipalFactory(), samlProfileSamlResponseBuilder, defaultSamlRegisteredServiceCachingMetadataResolver, (AbstractSaml20ObjectBuilder)new NonInflatingSaml20ObjectBuilder(openSamlConfigBean), defaultPrincipalResolver, casSamlIdPMetadataResolver);
        }
    }
}

