/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AccountProfileUpdateSecurityQuestionsAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountProfileUpdateSecurityQuestionsAction.class);
    private static final long INPUT_LENGTH_MINIMUM = 5L;
    private static final String CODE_FAILURE = "screen.account.securityquestions.failure";
    private static final String CODE_SUCCESS = "screen.account.securityquestions.success";
    private final PasswordManagementService passwordManagementService;
    private final CasConfigurationProperties casProperties;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        MessageContext messages = requestContext.getMessageContext();
        try {
            ParameterMap requestParameters = requestContext.getRequestParameters();
            List<String> questions = Arrays.stream((String[])requestParameters.getRequiredArray("questions", String.class)).distinct().toList();
            List<String> answers = Arrays.stream((String[])requestParameters.getRequiredArray("answers", String.class)).distinct().toList();
            FunctionUtils.throwIf((questions.size() != answers.size() ? 1 : 0) != 0, () -> new IllegalArgumentException("Security questions do not match the given answers"));
            LinkedMultiValueMap securityQuestions = new LinkedMultiValueMap();
            for (int i = 0; i < questions.size(); ++i) {
                String question = questions.get(i).trim();
                String answer = answers.get(i).trim();
                if (!StringUtils.isNotBlank((CharSequence)question) || !StringUtils.isNotBlank((CharSequence)answer) || StringUtils.equalsIgnoreCase((CharSequence)question, (CharSequence)answer) || (long)question.length() < 5L || (long)answer.length() < 5L) continue;
                securityQuestions.put((Object)question, List.of(answer));
            }
            FunctionUtils.throwIf((boolean)securityQuestions.isEmpty(), () -> new IllegalArgumentException("Security questions cannot be empty or unspecified"));
            Ticket tgt = WebUtils.getTicketGrantingTicket((RequestContext)requestContext);
            if (tgt instanceof AuthenticationAwareTicket) {
                AuthenticationAwareTicket aat = (AuthenticationAwareTicket)tgt;
                Principal principal = aat.getAuthentication().getPrincipal();
                PasswordManagementQuery query = PasswordManagementQuery.builder().username(principal.getId()).securityQuestions(securityQuestions).build();
                LOGGER.debug("Updating security questions for [{}]", (Object)query);
                this.passwordManagementService.updateSecurityQuestions(query);
                messages.addMessage(new MessageBuilder().info().code(CODE_SUCCESS).build());
                return this.success();
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            messages.addMessage(new MessageBuilder().error().code(CODE_FAILURE).build());
        }
        return this.error();
    }

    @Generated
    public AccountProfileUpdateSecurityQuestionsAction(PasswordManagementService passwordManagementService, CasConfigurationProperties casProperties) {
        this.passwordManagementService = passwordManagementService;
        this.casProperties = casProperties;
    }

    @Generated
    public PasswordManagementService getPasswordManagementService() {
        return this.passwordManagementService;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

