/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementAction;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifyPasswordResetRequestAction
extends BasePasswordManagementAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyPasswordResetRequestAction.class);
    public static final String EVENT_ID_SECURITY_QUESTIONS_DISABLED = "questionsDisabled";
    private final CasConfigurationProperties casProperties;
    private final PasswordManagementService passwordManagementService;
    private final TicketRegistrySupport ticketRegistrySupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String transientTicket = request.getParameter("pswdrst");
        PasswordResetRequest resetRequest = null;
        try {
            Event event;
            String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
            if (StringUtils.isBlank((CharSequence)transientTicket) && StringUtils.isBlank((CharSequence)tgt)) {
                LOGGER.error("Password reset token is missing");
                Event event2 = this.error();
                this.removeTransientTicketIfNecessary(resetRequest);
                return event2;
            }
            resetRequest = this.getPasswordResetRequestFrom(requestContext, transientTicket).orElseGet(() -> this.getPasswordResetRequestFrom(tgt));
            PasswordManagementQuery query = PasswordManagementQuery.builder().username(resetRequest.getUsername()).build();
            PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
            if (pm.getReset().isSecurityQuestionsEnabled()) {
                List questions = (List)FunctionUtils.doUnchecked(() -> PasswordManagementService.canonicalizeSecurityQuestions((Map)this.passwordManagementService.getSecurityQuestions(query)));
                if (questions.isEmpty()) {
                    LOGGER.warn("No security questions could be found for [{}]", (Object)resetRequest);
                    Event event3 = this.error();
                    this.removeTransientTicketIfNecessary(resetRequest);
                    return event3;
                }
                PasswordManagementWebflowUtils.putPasswordResetSecurityQuestions(requestContext, questions);
            } else {
                LOGGER.debug("Security questions are not enabled");
            }
            PasswordManagementWebflowUtils.putPasswordResetUsername(requestContext, resetRequest.getUsername());
            PasswordManagementWebflowUtils.putPasswordResetSecurityQuestionsEnabled(requestContext, pm.getReset().isSecurityQuestionsEnabled());
            if (pm.getReset().isSecurityQuestionsEnabled()) {
                LOGGER.trace("Security questions are enabled; proceeding...");
                event = this.success();
                this.removeTransientTicketIfNecessary(resetRequest);
                return event;
            }
            event = new EventFactorySupport().event((Object)this, EVENT_ID_SECURITY_QUESTIONS_DISABLED);
            this.removeTransientTicketIfNecessary(resetRequest);
            return event;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (String)"Password reset token could not be located or verified", (Throwable)e);
            Event event = this.error();
            return event;
        }
        finally {
            this.removeTransientTicketIfNecessary(resetRequest);
        }
    }

    private void removeTransientTicketIfNecessary(PasswordResetRequest resetRequest) {
        Optional.ofNullable(resetRequest).map(PasswordResetRequest::getPasswordResetTicket).filter(Objects::nonNull).filter(r -> r.getExpirationPolicy().isExpired((TicketGrantingTicketAwareTicket)r)).ifPresent(token -> FunctionUtils.doAndHandle(__ -> this.ticketRegistrySupport.getTicketRegistry().deleteTicket((Ticket)token)));
    }

    private PasswordResetRequest getPasswordResetRequestFrom(String tgt) {
        Principal principal = this.ticketRegistrySupport.getAuthenticatedPrincipalFrom(tgt);
        return ((PasswordResetRequest.PasswordResetRequestBuilder)PasswordResetRequest.builder().username(principal.getId())).build();
    }

    private Optional<PasswordResetRequest> getPasswordResetRequestFrom(RequestContext requestContext, String transientTicket) {
        return Optional.ofNullable(transientTicket).map(Unchecked.function(__ -> {
            TicketRegistry ticketRegistry = this.ticketRegistrySupport.getTicketRegistry();
            TransientSessionTicket passwordResetTicket = (TransientSessionTicket)ticketRegistry.getTicket(transientTicket, TransientSessionTicket.class);
            passwordResetTicket.update();
            ticketRegistry.updateTicket((Ticket)passwordResetTicket);
            String token = passwordResetTicket.getProperties().get("token").toString();
            PasswordManagementWebflowUtils.putPasswordResetToken(requestContext, token);
            return ((PasswordResetRequest.PasswordResetRequestBuilder)((PasswordResetRequest.PasswordResetRequestBuilder)PasswordResetRequest.builder().passwordResetTicket(passwordResetTicket)).username(this.passwordManagementService.parseToken(token))).build();
        }));
    }

    @Generated
    public VerifyPasswordResetRequestAction(CasConfigurationProperties casProperties, PasswordManagementService passwordManagementService, TicketRegistrySupport ticketRegistrySupport) {
        this.casProperties = casProperties;
        this.passwordManagementService = passwordManagementService;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    private static final class PasswordResetRequest {
        private final String username;
        private final TransientSessionTicket passwordResetTicket;

        @Generated
        protected PasswordResetRequest(PasswordResetRequestBuilder<?, ?> b) {
            this.username = b.username;
            this.passwordResetTicket = b.passwordResetTicket;
        }

        @Generated
        public static PasswordResetRequestBuilder<?, ?> builder() {
            return new PasswordResetRequestBuilderImpl();
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public TransientSessionTicket getPasswordResetTicket() {
            return this.passwordResetTicket;
        }

        @Generated
        public static abstract class PasswordResetRequestBuilder<C extends PasswordResetRequest, B extends PasswordResetRequestBuilder<C, B>> {
            @Generated
            private String username;
            @Generated
            private TransientSessionTicket passwordResetTicket;

            @Generated
            public B username(String username) {
                this.username = username;
                return this.self();
            }

            @Generated
            public B passwordResetTicket(TransientSessionTicket passwordResetTicket) {
                this.passwordResetTicket = passwordResetTicket;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "VerifyPasswordResetRequestAction.PasswordResetRequest.PasswordResetRequestBuilder(username=" + this.username + ", passwordResetTicket=" + String.valueOf(this.passwordResetTicket) + ")";
            }
        }

        @Generated
        private static final class PasswordResetRequestBuilderImpl
        extends PasswordResetRequestBuilder<PasswordResetRequest, PasswordResetRequestBuilderImpl> {
            @Generated
            private PasswordResetRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected PasswordResetRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public PasswordResetRequest build() {
                return new PasswordResetRequest(this);
            }
        }
    }
}

