/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.function.Supplier;
import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.GroovyDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.RestfulDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.ScimDelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProvisioningProperties;
import org.apereo.cas.scim.v2.ScimV2PrincipalAttributeMapper;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication})
@Configuration(value="DelegatedAuthenticationProvisioningConfiguration", proxyBeanMethods=false)
class DelegatedAuthenticationProvisioningConfiguration {
    DelegatedAuthenticationProvisioningConfiguration() {
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanProvisionerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationEventExecutionPlanProvisionerConfiguration {
        DelegatedAuthenticationEventExecutionPlanProvisionerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"groovyDelegatedClientUserProfileProvisioner"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public Supplier<DelegatedClientUserProfileProvisioner> groovyDelegatedClientUserProfileProvisioner(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (Supplier)BeanSupplier.of(Supplier.class).when(BeanCondition.on((String)"cas.authn.pac4j.provisioning.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
                Resource script = provisioning.getGroovy().getLocation();
                return () -> new GroovyDelegatedClientUserProfileProvisioner(script);
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restDelegatedClientUserProfileProvisioner"})
        public Supplier<DelegatedClientUserProfileProvisioner> restDelegatedClientUserProfileProvisioner(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
            return (Supplier)BeanSupplier.of(Supplier.class).when(BeanCondition.on((String)"cas.authn.pac4j.provisioning.rest.url").isUrl().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
                return () -> new RestfulDelegatedClientUserProfileProvisioner((RestEndpointProperties)provisioning.getRest());
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="DelegatedAuthenticationScimProvisioningConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={ScimV2PrincipalAttributeMapper.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Provisioning}, module="pac4j")
    static class DelegatedAuthenticationScimProvisioningConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pac4j.provisioning.scim.enabled").isTrue();

        DelegatedAuthenticationScimProvisioningConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"pac4jScimDelegatedClientUserProfileProvisioner"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Supplier<DelegatedClientUserProfileProvisioner> pac4jScimDelegatedClientUserProfileProvisioner(ConfigurableApplicationContext applicationContext, @Qualifier(value="principalProvisioner") ObjectProvider<PrincipalProvisioner> principalProvisioner) {
            return (Supplier)BeanSupplier.of(Supplier.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> new ScimDelegatedClientUserProfileProvisioner((PrincipalProvisioner)principalProvisioner.getObject())).otherwiseProxy().get();
        }
    }
}

