/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.actions.logout.DelegatedAuthenticationClientLogoutRequest;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.logout.processor.SAML2LogoutProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationClientFinishLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationClientFinishLogoutAction.class);
    private final DelegatedIdentityProviders identityProviders;
    private final SessionStore sessionStore;

    protected Event doExecuteInternal(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response);
        String clientName = DelegationWebflowUtils.getDelegatedAuthenticationClientName((RequestContext)requestContext);
        if (clientName == null) {
            clientName = requestContext.getRequestParameters().get("RelayState");
            if (StringUtils.isNotBlank((CharSequence)clientName)) {
                this.identityProviders.findClient(clientName).filter(SAML2Client.class::isInstance).map(SAML2Client.class::cast).ifPresent(client -> FunctionUtils.doAndHandle(__ -> {
                    LOGGER.debug("Located client from relay-state: [{}]", client);
                    CallContext callContext = new CallContext((WebContext)context, this.sessionStore);
                    client.getCredentialsExtractor().extract(callContext).ifPresent(logoutCredentials -> {
                        HttpAction result = client.getLogoutProcessor().processLogout(callContext, logoutCredentials);
                        JEEHttpActionAdapter.INSTANCE.adapt(result, (WebContext)context);
                    });
                }));
            }
        } else {
            String logoutRedirect = (String)WebUtils.getLogoutRedirectUrl((RequestContext)requestContext, String.class);
            this.identityProviders.findClient(clientName).filter(SAML2Client.class::isInstance).map(SAML2Client.class::cast).ifPresent(client -> {
                DelegatedAuthenticationClientLogoutRequest logoutRequest = (DelegatedAuthenticationClientLogoutRequest)DelegationWebflowUtils.getDelegatedAuthenticationLogoutRequest((RequestContext)requestContext, DelegatedAuthenticationClientLogoutRequest.class);
                Optional.ofNullable(logoutRequest).filter(__ -> StringUtils.isNotBlank((CharSequence)logoutRedirect)).ifPresent(__ -> {
                    LOGGER.debug("Located client from webflow state: [{}]", client);
                    SAML2LogoutProcessor validator = (SAML2LogoutProcessor)client.getLogoutProcessor();
                    validator.setPostLogoutURL(logoutRedirect);
                    LOGGER.debug("Captured post logout url: [{}]", (Object)logoutRedirect);
                    WebUtils.putLogoutRedirectUrl((RequestContext)requestContext, null);
                });
            });
        }
        return null;
    }

    @Generated
    public DelegatedAuthenticationClientFinishLogoutAction(DelegatedIdentityProviders identityProviders, SessionStore sessionStore) {
        this.identityProviders = identityProviders;
        this.sessionStore = sessionStore;
    }
}

