/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.provision.DelegatedAuthenticationFailureException;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.view.DynamicHtmlView;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationRedirectAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationRedirectAction.class);
    protected final DelegatedClientAuthenticationConfigurationContext configContext;
    protected final DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        TransientSessionTicket ticket = (TransientSessionTicket)requestContext.getFlowScope().get(TransientSessionTicket.class.getName(), TransientSessionTicket.class);
        IndirectClient client = this.locateClientIdentityProvider(ticket);
        this.initializeClientIdentityProvider(client);
        RedirectionAction action = this.getRedirectionAction(ticket, requestContext);
        LOGGER.debug("Determined final redirect action for client [{}] as [{}]", (Object)client, (Object)action.toString());
        if (action instanceof WithLocationAction) {
            LOGGER.debug("Redirecting client [{}] based on identifier [{}]", (Object)client.getName(), (Object)ticket.getId());
            this.handleIdentityProviderWithExternalRedirect(requestContext, client, action);
        }
        if (action instanceof WithContentAction) {
            this.handleIdentityProviderWithDynamicContent(requestContext, client, action);
        }
        return new EventFactorySupport().event((Object)this, "success");
    }

    protected RedirectionAction getRedirectionAction(TransientSessionTicket ticket, RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext webContext = new JEEContext(request, response);
        Map properties = ticket.getProperties();
        if (properties.containsKey("ForceAuthn")) {
            webContext.setRequestAttribute("ForceAuthn", (Object)true);
        }
        if (properties.containsKey("Passive")) {
            webContext.setRequestAttribute("Passive", (Object)true);
        }
        Optional.ofNullable(ticket.getService()).ifPresent(Unchecked.consumer(service -> this.configureWebContextForRegisteredService((WebContext)webContext, ticket)));
        String clientName = (String)ticket.getProperty(Client.class.getName(), String.class);
        return (RedirectionAction)this.configContext.getIdentityProviders().findClient(clientName).map(IndirectClient.class::cast).stream().peek(client -> this.configContext.getDelegatedClientAuthenticationRequestCustomizers().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<DelegatedClientAuthenticationRequestCustomizer>)AnnotationAwareOrderComparator.INSTANCE).filter(Unchecked.predicate(contributor -> contributor.supports(client, (WebContext)webContext))).forEach(Unchecked.consumer(contributor -> contributor.customize(client, (WebContext)webContext)))).map(client -> {
            CallContext callContext = new CallContext((WebContext)webContext, this.configContext.getSessionStore());
            return client.getRedirectionActionBuilder().getRedirectionAction(callContext);
        }).flatMap(Optional::stream).findFirst().orElseThrow();
    }

    protected void configureWebContextForRegisteredService(WebContext webContext, TransientSessionTicket ticket) throws Throwable {
        RegisteredService registeredService = this.configContext.getServicesManager().findServiceBy(ticket.getService());
        AuditableContext audit = AuditableContext.builder().service(ticket.getService()).registeredService(registeredService).build();
        AuditableExecutionResult result = this.configContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        result.throwExceptionIfNeeded();
        if (!registeredService.getProperties().isEmpty()) {
            List<RegisteredServiceProperty.RegisteredServiceProperties> delegatedAuthnProperties = Arrays.stream(RegisteredServiceProperty.RegisteredServiceProperties.values()).filter(prop -> prop.isMemberOf(RegisteredServiceProperty.RegisteredServicePropertyGroups.DELEGATED_AUTHN)).collect(Collectors.toList());
            this.configureWebContextForRegisteredServiceProperties(registeredService, webContext, delegatedAuthnProperties);
            List<RegisteredServiceProperty.RegisteredServiceProperties> saml2ServiceProperties = Arrays.stream(RegisteredServiceProperty.RegisteredServiceProperties.values()).filter(prop -> prop.isMemberOf(RegisteredServiceProperty.RegisteredServicePropertyGroups.DELEGATED_AUTHN_SAML2)).collect(Collectors.toList());
            this.configureWebContextForRegisteredServiceProperties(registeredService, webContext, saml2ServiceProperties);
            List<RegisteredServiceProperty.RegisteredServiceProperties> oidcProperties = Arrays.stream(RegisteredServiceProperty.RegisteredServiceProperties.values()).filter(prop -> prop.isMemberOf(RegisteredServiceProperty.RegisteredServicePropertyGroups.DELEGATED_AUTHN_OIDC)).collect(Collectors.toList());
            this.configureWebContextForRegisteredServiceProperties(registeredService, webContext, oidcProperties);
        }
    }

    protected void initializeClientIdentityProvider(IndirectClient client) throws Throwable {
        client.init();
        FunctionUtils.throwIf((!client.isInitialized() ? 1 : 0) != 0, DelegatedAuthenticationFailureException::new);
    }

    protected IndirectClient locateClientIdentityProvider(TransientSessionTicket ticket) {
        String clientName = (String)ticket.getProperty(Client.class.getName(), String.class);
        return this.configContext.getIdentityProviders().findClient(clientName).map(IndirectClient.class::cast).stream().findFirst().orElseThrow();
    }

    protected void handleIdentityProviderWithDynamicContent(RequestContext requestContext, IndirectClient client, RedirectionAction action) throws Exception {
        WithContentAction seeOtherAction = (WithContentAction)action;
        DynamicHtmlView view = new DynamicHtmlView(seeOtherAction.getContent());
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        LOGGER.debug("Rendering dynamic content [{}] for client [{}]", (Object)view.html(), (Object)client.getName());
        view.render(Map.of(), request, response);
        requestContext.getExternalContext().recordResponseComplete();
    }

    protected void handleIdentityProviderWithExternalRedirect(RequestContext requestContext, IndirectClient client, RedirectionAction action) throws Exception {
        WithLocationAction foundAction = (WithLocationAction)action;
        URIBuilder builder = new URIBuilder(foundAction.getLocation());
        String url = builder.toString();
        LOGGER.debug("Redirecting to [{}] via client [{}]", (Object)url, (Object)client.getName());
        requestContext.getExternalContext().requestExternalRedirect(url);
    }

    protected void configureWebContextForRegisteredServiceProperties(RegisteredService registeredService, WebContext webContext, List<RegisteredServiceProperty.RegisteredServiceProperties> properties) {
        properties.stream().filter(prop -> prop.isAssignedTo(registeredService)).forEach(prop -> webContext.setRequestAttribute(prop.getPropertyName(), prop.getTypedPropertyValue(registeredService)));
    }

    @Generated
    public DelegatedClientAuthenticationRedirectAction(DelegatedClientAuthenticationConfigurationContext configContext, DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager) {
        this.configContext = configContext;
        this.delegatedClientAuthenticationWebflowManager = delegatedClientAuthenticationWebflowManager;
    }
}

