/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.DelegatedAuthenticationAuditResourceResolver;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.principal.DefaultDelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.provision.ChainingDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.cookie.PinnableCookieProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCoreProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.configuration.model.support.replication.SessionReplicationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.discovery.CasServerProfileCustomizer;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.pac4j.TicketRegistrySessionStore;
import org.apereo.cas.pac4j.client.DelegatedClientNameExtractor;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviderFactory;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.pac4j.authentication.DelegatedClientAuthenticationMetaDataPopulator;
import org.apereo.cas.support.pac4j.authentication.clients.DefaultDelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.support.pac4j.authentication.clients.RefreshableDelegatedIdentityProviders;
import org.apereo.cas.support.pac4j.authentication.clients.RestfulDelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.handler.support.DelegatedClientAuthenticationHandler;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.DelegatedClientAuthenticationDistributedSessionCookieCipherExecutor;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.mgmr.DefaultCasCookieValueManager;
import org.apereo.cas.web.support.mgmr.DefaultCookieSameSitePolicy;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication})
@AutoConfiguration
public class DelegatedAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationEventExecutionPlanConfiguration.class);
    private static final String AUTHENTICATION_DELEGATION_PREFIX = "AuthnDelegation";

    @Configuration(value="DelegatedAuthenticationDiscoveryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={CasServerProfileCustomizer.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Discovery})
    public static class DelegatedAuthenticationDiscoveryConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedAuthenticationCasServerProfileCustomizer"})
        @Bean
        public CasServerProfileCustomizer delegatedAuthenticationCasServerProfileCustomizer(@Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, CasConfigurationProperties casProperties) {
            Set clients = identityProviders.findAllClients().stream().map(Client::getName).collect(Collectors.toSet());
            return profile -> profile.getDetails().put("delegatedClientTypesSupported", clients);
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanBaseConfiguration {
        @ConditionalOnMissingBean(name={"pac4jAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer pac4jAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, @Qualifier(value="clientAuthenticationHandler") AuthenticationHandler clientAuthenticationHandler, @Qualifier(value="clientAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return plan -> {
                if (!identityProviders.findAllClients().isEmpty()) {
                    LOGGER.info("Registering delegated authentication clients...");
                    plan.registerAuthenticationHandlerWithPrincipalResolver(clientAuthenticationHandler, defaultPrincipalResolver);
                    plan.registerAuthenticationMetadataPopulator(clientAuthenticationMetaDataPopulator);
                }
            };
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanLogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanLogoutConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedAuthenticationLogoutExecutionPlanConfigurer"})
        public LogoutExecutionPlanConfigurer delegatedAuthenticationLogoutExecutionPlanConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return plan -> {
                boolean replicate = casProperties.getAuthn().getPac4j().getCore().getSessionReplication().isReplicateSessions();
                if (replicate) {
                    plan.registerLogoutPostProcessor(ticketGrantingTicket -> {
                        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
                        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
                        if (request != null && response != null) {
                            delegatedClientDistributedSessionStore.destroySession((WebContext)new JEEContext(request, response));
                        }
                    });
                }
            };
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanAuditPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanAuditPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditTrailRecordResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer delegatedAuthenticationAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="delegatedAuthenticationAuditResourceResolver") AuditResourceResolver delegatedAuthenticationAuditResourceResolver, @Qualifier(value="authenticationActionResolver") AuditActionResolver authenticationActionResolver) {
            return plan -> {
                plan.registerAuditActionResolver("DELEGATED_CLIENT_ACTION_RESOLVER", authenticationActionResolver);
                plan.registerAuditResourceResolver("DELEGATED_CLIENT_RESOURCE_RESOLVER", delegatedAuthenticationAuditResourceResolver);
            };
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanAuditConfiguration {
        @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver delegatedAuthenticationAuditResourceResolver() {
            return new DelegatedAuthenticationAuditResourceResolver();
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanClientConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"delegatedAuthenticationCredentialExtractor"})
        public DelegatedAuthenticationCredentialExtractor delegatedAuthenticationCredentialExtractor(@Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return new DefaultDelegatedAuthenticationCredentialExtractor(delegatedClientDistributedSessionStore);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"delegatedIdentityProviders"})
        public DelegatedIdentityProviders delegatedIdentityProviders(CasConfigurationProperties casProperties, @Qualifier(value="pac4jDelegatedClientFactory") DelegatedIdentityProviderFactory pac4jDelegatedIdentityProviderFactory) {
            return new RefreshableDelegatedIdentityProviders(casProperties.getServer().getLoginUrl(), pac4jDelegatedIdentityProviderFactory);
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanClientFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanClientFactoryConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"pac4jDelegatedClientNameExtractor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientNameExtractor pac4jDelegatedClientNameExtractor() {
            return DelegatedClientNameExtractor.fromHttpRequest();
        }

        @Bean
        @ConditionalOnMissingBean(name={"pac4jDelegatedClientFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedIdentityProviderFactory pac4jDelegatedClientFactory(@Qualifier(value="delegatedSaml2ClientSAMLMessageStoreFactory") ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory, CasConfigurationProperties casProperties, ObjectProvider<List<DelegatedClientFactoryCustomizer>> customizerList, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
            Pac4jDelegatedAuthenticationCoreProperties core = casProperties.getAuthn().getPac4j().getCore();
            Cache clientsCache = Caffeine.newBuilder().maximumSize(core.getCacheSize()).expireAfterAccess(Beans.newDuration((String)core.getCacheDuration())).build();
            List customizers = Optional.ofNullable((List)customizerList.getIfAvailable()).map(result -> {
                AnnotationAwareOrderComparator.sortIfNecessary((Object)result);
                return result;
            }).orElseGet(() -> new ArrayList(0));
            if (StringUtils.isNotBlank((CharSequence)casProperties.getAuthn().getPac4j().getRest().getUrl())) {
                return new RestfulDelegatedIdentityProviderFactory((Collection)customizers, casSslContext, casProperties, samlMessageStoreFactory, clientsCache);
            }
            return new DefaultDelegatedIdentityProviderFactory(casProperties, (Collection)customizers, casSslContext, samlMessageStoreFactory, clientsCache);
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanProvisionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanProvisionConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"clientUserProfileProvisioner"})
        public DelegatedClientUserProfileProvisioner clientUserProfileProvisioner(ObjectProvider<List<Supplier<DelegatedClientUserProfileProvisioner>>> provisioners) {
            List results = ((List)provisioners.getIfAvailable(() -> CollectionUtils.wrapList((Object[])new Supplier[]{DelegatedClientUserProfileProvisioner::noOp}))).stream().filter(BeanSupplier::isNotProxy).map(Supplier::get).collect(Collectors.toList());
            return new ChainingDelegatedClientUserProfileProvisioner(results);
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanHandlerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanHandlerConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"clientAuthenticationHandler"})
        public AuthenticationHandler clientAuthenticationHandler(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="clientPrincipalFactory") PrincipalFactory clientPrincipalFactory, @Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, @Qualifier(value="clientUserProfileProvisioner") DelegatedClientUserProfileProvisioner clientUserProfileProvisioner, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            Pac4jDelegatedAuthenticationCoreProperties pac4j = casProperties.getAuthn().getPac4j().getCore();
            DelegatedClientAuthenticationHandler handler = new DelegatedClientAuthenticationHandler(pac4j, servicesManager, clientPrincipalFactory, identityProviders, clientUserProfileProvisioner, delegatedClientDistributedSessionStore, applicationContext);
            handler.setTypedIdUsed(pac4j.isTypedIdUsed());
            handler.setPrincipalAttributeId(pac4j.getPrincipalIdAttribute());
            return handler;
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanMetadataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanMetadataConfiguration {
        @ConditionalOnMissingBean(name={"clientAuthenticationMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator() {
            return new DelegatedClientAuthenticationMetaDataPopulator();
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanCoreConfiguration {
        @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionCookieCipherExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CipherExecutor delegatedClientDistributedSessionCookieCipherExecutor(CasConfigurationProperties casProperties) {
            SessionReplicationProperties replication = casProperties.getAuthn().getPac4j().getCore().getSessionReplication();
            return (CipherExecutor)FunctionUtils.doIf((boolean)replication.isReplicateSessions(), () -> {
                CookieSessionReplicationProperties cookie = replication.getCookie();
                EncryptionJwtSigningJwtCryptographyProperties crypto = cookie.getCrypto();
                boolean enabled = crypto.isEnabled();
                if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
                    LOGGER.warn("Encryption/Signing is not enabled explicitly in the configuration for cookie [{}], yet signing/encryption keys are defined for operations. CAS will proceed to enable the cookie encryption/signing functionality.", (Object)cookie.getName());
                    enabled = true;
                }
                return enabled ? CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, DelegatedClientAuthenticationDistributedSessionCookieCipherExecutor.class) : CipherExecutor.noOp();
            }, CipherExecutor::noOp).get();
        }

        @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder delegatedClientDistributedSessionCookieGenerator(@Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, @Qualifier(value="delegatedClientDistributedSessionCookieCipherExecutor") CipherExecutor delegatedClientDistributedSessionCookieCipherExecutor, CasConfigurationProperties casProperties) {
            CookieSessionReplicationProperties cookie = casProperties.getAuthn().getPac4j().getCore().getSessionReplication().getCookie();
            if (StringUtils.isBlank((CharSequence)cookie.getName())) {
                cookie.setName("DISSESSIONAuthnDelegation");
            }
            return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie, (CookieValueManager)new DefaultCasCookieValueManager(delegatedClientDistributedSessionCookieCipherExecutor, geoLocationService, DefaultCookieSameSitePolicy.INSTANCE, (PinnableCookieProperties)cookie));
        }

        @ConditionalOnMissingBean(name={"clientPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory clientPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="DelegatedAuthenticationEventExecutionPlanSessionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationEventExecutionPlanSessionConfiguration {
        @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SessionStore delegatedClientDistributedSessionStore(CasConfigurationProperties casProperties, @Qualifier(value="delegatedClientDistributedSessionCookieGenerator") CasCookieBuilder delegatedClientDistributedSessionCookieGenerator, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            SessionReplicationProperties replicationProps = casProperties.getAuthn().getPac4j().getCore().getSessionReplication();
            if (replicationProps.isReplicateSessions()) {
                return new TicketRegistrySessionStore(ticketRegistry, ticketFactory, delegatedClientDistributedSessionCookieGenerator);
            }
            JEESessionStore sessionStore = new JEESessionStore();
            sessionStore.setPrefix(DelegatedAuthenticationEventExecutionPlanConfiguration.AUTHENTICATION_DELEGATION_PREFIX);
            return sessionStore;
        }
    }
}

