/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.okta.sdk.client.Client;
import java.util.List;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.okta.BaseOktaApiProperties;
import org.apereo.cas.configuration.model.support.okta.OktaPrincipalAttributesProperties;
import org.apereo.cas.okta.OktaConfigurationFactory;
import org.apereo.cas.okta.OktaPersonAttributeDao;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="okta")
@Configuration(value="OktaPersonDirectoryConfiguration", proxyBeanMethods=false)
class OktaPersonDirectoryConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.okta.organization-url");

    OktaPersonDirectoryConfiguration() {
    }

    @ConditionalOnMissingBean(name={"oktaPersonDirectoryClient"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Client oktaPersonDirectoryClient(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (Client)BeanSupplier.of(Client.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            OktaPrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository().getOkta();
            return OktaConfigurationFactory.buildClient((BaseOktaApiProperties)properties);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"oktaPersonAttributeDaos"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<PersonAttributeDao> oktaPersonAttributeDaos(ConfigurableApplicationContext applicationContext, @Qualifier(value="oktaPersonDirectoryClient") Client oktaPersonDirectoryClient, CasConfigurationProperties casProperties) {
        return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            OktaPrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository().getOkta();
            OktaPersonAttributeDao dao = new OktaPersonAttributeDao(oktaPersonDirectoryClient);
            dao.setUsernameAttributeProvider((UsernameAttributeProvider)new SimpleUsernameAttributeProvider(properties.getUsernameAttribute()));
            dao.setOrder(properties.getOrder());
            FunctionUtils.doIfNotNull((Object)properties.getId(), id -> dao.setId(new String[]{id}));
            return BeanContainer.of((List)CollectionUtils.wrapList((Object[])new OktaPersonAttributeDao[]{dao}));
        }).otherwise(BeanContainer::empty).get();
    }

    @ConditionalOnMissingBean(name={"oktaAttributeRepositoryPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PersonDirectoryAttributeRepositoryPlanConfigurer oktaAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="oktaPersonAttributeDaos") BeanContainer<PersonAttributeDao> oktaPersonAttributeDaos) {
        return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> oktaPersonAttributeDaos.toList().forEach(arg_0 -> ((PersonDirectoryAttributeRepositoryPlan)plan).registerAttributeRepository(arg_0))).otherwiseProxy().get();
    }
}

