/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeyStoreListener;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreListener;
import org.apereo.cas.oidc.jwks.generator.OidcDefaultJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcGroovyJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcRestfulJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.rotation.OidcDefaultJsonWebKeystoreRotationService;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.scheduling.annotation.Scheduled;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect})
@Configuration(value="OidcJwksConfiguration", proxyBeanMethods=false)
class OidcJwksConfiguration {
    OidcJwksConfiguration() {
    }

    @Configuration(value="OidcEndpointsJwksGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcEndpointsJwksGeneratorConfiguration {
        OidcEndpointsJwksGeneratorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCacheLoader"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CacheLoader<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCacheLoader(@Qualifier(value="oidcJsonWebKeystoreGeneratorService") OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService) {
            return new OidcDefaultJsonWebKeystoreCacheLoader(oidcJsonWebKeystoreGeneratorService);
        }

        @ConditionalOnMissingBean(name={"oidcJsonWebKeyStoreListener"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public OidcJsonWebKeyStoreListener oidcJsonWebKeyStoreListener(@Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache) {
            return new OidcDefaultJsonWebKeyStoreListener(oidcDefaultJsonWebKeystoreCache);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCache"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCache(@Qualifier(value="oidcDefaultJsonWebKeystoreCacheLoader") CacheLoader<OidcJsonWebKeyCacheKey, JsonWebKeySet> oidcDefaultJsonWebKeystoreCacheLoader, CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            Duration expiration = Beans.newDuration((String)oidc.getJwks().getCore().getJwksCacheExpiration());
            return Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(expiration).build(oidcDefaultJsonWebKeystoreCacheLoader);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"groovyOidcJsonWebKeystoreGeneratorService"})
        @ConditionalOnMissingGraalVMNativeImage
        public Supplier<OidcJsonWebKeystoreGeneratorService> groovyOidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            return (Supplier)BeanSupplier.of(Supplier.class).when(BeanCondition.on((String)"cas.authn.oidc.jwks.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> new OidcGroovyJsonWebKeystoreGeneratorService(oidc.getJwks().getGroovy().getLocation())).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restOidcJsonWebKeystoreGeneratorService"})
        public Supplier<OidcJsonWebKeystoreGeneratorService> restOidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            return (Supplier)BeanSupplier.of(Supplier.class).when(BeanCondition.on((String)"cas.authn.oidc.jwks.rest.url").isUrl().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> new OidcRestfulJsonWebKeystoreGeneratorService(oidc)).otherwiseProxy().get();
        }

        @Bean(initMethod="generate")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreGeneratorService"})
        public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, List<Supplier<OidcJsonWebKeystoreGeneratorService>> oidsJwksSuppliers) {
            Supplier<OidcJsonWebKeystoreGeneratorService> supplier = oidsJwksSuppliers.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).filter(BeanSupplier::isNotProxy).findFirst().orElse(() -> {
                OidcProperties oidc = casProperties.getAuthn().getOidc();
                return new OidcDefaultJsonWebKeystoreGeneratorService(oidc, applicationContext);
            });
            return supplier.get();
        }
    }

    @Configuration(value="OidcEndpointsJwksRotationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcEndpointsJwksRotationConfiguration {
        OidcEndpointsJwksRotationConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreRotationService"})
        public OidcJsonWebKeystoreRotationService oidcJsonWebKeystoreRotationService(@Qualifier(value="oidcJsonWebKeystoreGeneratorService") OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService, CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            return new OidcDefaultJsonWebKeystoreRotationService(oidc, oidcJsonWebKeystoreGeneratorService);
        }

        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreRotationScheduler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Runnable oidcJsonWebKeystoreRotationScheduler(ConfigurableApplicationContext applicationContext, @Qualifier(value="oidcJsonWebKeystoreRotationService") OidcJsonWebKeystoreRotationService oidcJsonWebKeystoreRotationService) throws Exception {
            return (Runnable)BeanSupplier.of(Runnable.class).when(BeanCondition.on((String)"cas.authn.oidc.jwks.rotation.schedule").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new OidcJsonWebKeystoreRotationScheduler(oidcJsonWebKeystoreRotationService)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreRevocationScheduler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Runnable oidcJsonWebKeystoreRevocationScheduler(ConfigurableApplicationContext applicationContext, @Qualifier(value="oidcJsonWebKeystoreRotationService") OidcJsonWebKeystoreRotationService oidcJsonWebKeystoreRotationService) {
            return (Runnable)BeanSupplier.of(Runnable.class).when(BeanCondition.on((String)"cas.authn.oidc.jwks.revocation.schedule.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new OidcJsonWebKeystoreRevocationScheduler(oidcJsonWebKeystoreRotationService)).otherwiseProxy().get();
        }

        static class OidcJsonWebKeystoreRevocationScheduler
        implements Runnable {
            @Generated
            private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeystoreRevocationScheduler.class);
            private final OidcJsonWebKeystoreRotationService rotationService;

            @Override
            @Scheduled(cron="${cas.authn.oidc.jwks.revocation.schedule.cron-expression:}", zone="${cas.authn.oidc.jwks.revocation.schedule.cron-time-zone:}", initialDelayString="${cas.authn.oidc.jwks.revocation.schedule.start-delay:PT60S}", fixedDelayString="${cas.authn.oidc.jwks.revocation.schedule.repeat-interval:P14D}")
            public void run() {
                FunctionUtils.doUnchecked(__ -> {
                    LOGGER.info("Starting to revoke keys in the OIDC keystore...");
                    this.rotationService.revoke();
                }, (Object[])new Object[0]);
            }

            @Generated
            public OidcJsonWebKeystoreRevocationScheduler(OidcJsonWebKeystoreRotationService rotationService) {
                this.rotationService = rotationService;
            }
        }

        static class OidcJsonWebKeystoreRotationScheduler
        implements Runnable {
            @Generated
            private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeystoreRotationScheduler.class);
            private final OidcJsonWebKeystoreRotationService rotationService;

            @Override
            @Scheduled(cron="${cas.authn.oidc.jwks.rotation.schedule.cron-expression:}", initialDelayString="${cas.authn.oidc.jwks.rotation.schedule.start-delay:PT60S}", fixedDelayString="${cas.authn.oidc.jwks.rotation.schedule.repeat-interval:P90D}")
            public void run() {
                FunctionUtils.doUnchecked(__ -> {
                    LOGGER.info("Starting to rotate keys in the OIDC keystore...");
                    this.rotationService.rotate();
                }, (Object[])new Object[0]);
            }

            @Generated
            public OidcJsonWebKeystoreRotationScheduler(OidcJsonWebKeystoreRotationService rotationService) {
                this.rotationService = rotationService;
            }
        }
    }
}

