/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ConsentAccountProfilePrepareAction
extends BaseCasWebflowAction {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final ConsentEngine consentEngine;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = authentication.getPrincipal();
        Collection decisions = this.consentEngine.getConsentRepository().findConsentDecisions(principal.getId());
        List resolved = decisions.stream().map(Unchecked.function(d -> {
            Object decision = ((AccountProfileConsentDecision.AccountProfileConsentDecisionBuilder)((AccountProfileConsentDecision.AccountProfileConsentDecisionBuilder)((AccountProfileConsentDecision.AccountProfileConsentDecisionBuilder)((AccountProfileConsentDecision.AccountProfileConsentDecisionBuilder)((AccountProfileConsentDecision.AccountProfileConsentDecisionBuilder)((AccountProfileConsentDecision.AccountProfileConsentDecisionBuilder)AccountProfileConsentDecision.builder().id(d.getId())).service(d.getService())).createdDateTime(d.getCreatedDate())).attributes(this.consentEngine.resolveConsentableAttributesFrom(d))).options("screen.account.consent." + d.getOptions().name().toLowerCase(Locale.ENGLISH))).reminder(String.format("%s - %s", d.getReminder(), d.getReminderTimeUnit()))).build();
            ((AccountProfileConsentDecision)decision).setJson(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(decision));
            return decision;
        })).collect(Collectors.toList());
        if (!resolved.isEmpty()) {
            requestContext.getFlowScope().put("consentDecisions", resolved);
        }
        return null;
    }

    @Generated
    public ConsentAccountProfilePrepareAction(ConsentEngine consentEngine) {
        this.consentEngine = consentEngine;
    }

    private static final class AccountProfileConsentDecision
    implements Serializable {
        private static final long serialVersionUID = -5211708226232415390L;
        private final long id;
        private String service;
        private final Map<String, List<Object>> attributes;
        private final LocalDateTime createdDateTime;
        private final String options;
        private final String reminder;
        private String json;

        @Generated
        protected AccountProfileConsentDecision(AccountProfileConsentDecisionBuilder<?, ?> b) {
            this.id = b.id;
            this.service = b.service;
            this.attributes = b.attributes;
            this.createdDateTime = b.createdDateTime;
            this.options = b.options;
            this.reminder = b.reminder;
            this.json = b.json;
        }

        @Generated
        public static AccountProfileConsentDecisionBuilder<?, ?> builder() {
            return new AccountProfileConsentDecisionBuilderImpl();
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public String getService() {
            return this.service;
        }

        @Generated
        public Map<String, List<Object>> getAttributes() {
            return this.attributes;
        }

        @Generated
        public LocalDateTime getCreatedDateTime() {
            return this.createdDateTime;
        }

        @Generated
        public String getOptions() {
            return this.options;
        }

        @Generated
        public String getReminder() {
            return this.reminder;
        }

        @Generated
        public String getJson() {
            return this.json;
        }

        @Generated
        public void setJson(String json) {
            this.json = json;
        }

        @Generated
        public static abstract class AccountProfileConsentDecisionBuilder<C extends AccountProfileConsentDecision, B extends AccountProfileConsentDecisionBuilder<C, B>> {
            @Generated
            private long id;
            @Generated
            private String service;
            @Generated
            private Map<String, List<Object>> attributes;
            @Generated
            private LocalDateTime createdDateTime;
            @Generated
            private String options;
            @Generated
            private String reminder;
            @Generated
            private String json;

            @Generated
            public B id(long id) {
                this.id = id;
                return this.self();
            }

            @Generated
            public B service(String service) {
                this.service = service;
                return this.self();
            }

            @Generated
            public B attributes(Map<String, List<Object>> attributes) {
                this.attributes = attributes;
                return this.self();
            }

            @Generated
            public B createdDateTime(LocalDateTime createdDateTime) {
                this.createdDateTime = createdDateTime;
                return this.self();
            }

            @Generated
            public B options(String options) {
                this.options = options;
                return this.self();
            }

            @Generated
            public B reminder(String reminder) {
                this.reminder = reminder;
                return this.self();
            }

            @Generated
            public B json(String json) {
                this.json = json;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "ConsentAccountProfilePrepareAction.AccountProfileConsentDecision.AccountProfileConsentDecisionBuilder(id=" + this.id + ", service=" + this.service + ", attributes=" + String.valueOf(this.attributes) + ", createdDateTime=" + String.valueOf(this.createdDateTime) + ", options=" + this.options + ", reminder=" + this.reminder + ", json=" + this.json + ")";
            }
        }

        @Generated
        private static final class AccountProfileConsentDecisionBuilderImpl
        extends AccountProfileConsentDecisionBuilder<AccountProfileConsentDecision, AccountProfileConsentDecisionBuilderImpl> {
            @Generated
            private AccountProfileConsentDecisionBuilderImpl() {
            }

            @Override
            @Generated
            protected AccountProfileConsentDecisionBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AccountProfileConsentDecision build() {
                return new AccountProfileConsentDecision(this);
            }
        }
    }
}

