/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.CheckConsentRequiredAction;
import org.apereo.cas.web.flow.ConfirmConsentAction;
import org.apereo.cas.web.flow.ConsentAccountProfilePrepareAction;
import org.apereo.cas.web.flow.ConsentAccountProfileWebflowConfigurer;
import org.apereo.cas.web.flow.ConsentWebflowConfigurer;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnBean(name={"consentRepository"})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Consent})
@AutoConfiguration
public class CasConsentWebflowAutoConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.consent.core.enabled").isTrue().evenIfMissing();

    @Configuration(value="CasConsentAccountProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)
    static class CasConsentAccountProfileConfiguration {
        CasConsentAccountProfileConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"consentAccountProfilePrepareAction"})
        public Action consentAccountProfilePrepareAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="consentEngine") ConsentEngine consentEngine) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new ConsentAccountProfilePrepareAction(consentEngine)).withId("consentAccountProfilePrepareAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casConsentAccountProfileWebflowConfigurer"})
        @DependsOn(value={"accountProfileWebflowConfigurer"})
        public CasWebflowConfigurer casConsentAccountProfileWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new ConsentAccountProfileWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casConsentAccountProfileWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer casConsentAccountProfileWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="casConsentAccountProfileWebflowConfigurer") CasWebflowConfigurer casConsentAccountProfileWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(casConsentAccountProfileWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasConsentWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasConsentWebflowBaseConfiguration {
        CasConsentWebflowBaseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"consentWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer consentWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new ConsentWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"consentCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer consentCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="consentWebflowConfigurer") CasWebflowConfigurer consentWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(consentWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasConsentWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasConsentWebflowActionConfiguration {
        CasConsentWebflowActionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"checkConsentRequiredAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action checkConsentRequiredAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="consentEngine") ConsentEngine consentEngine, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="consentActivationStrategy") ConsentActivationStrategy consentActivationStrategy) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new CheckConsentRequiredAction(servicesManager, authenticationRequestServiceSelectionStrategies, consentEngine, casProperties, attributeDefinitionStore, applicationContext, consentActivationStrategy)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("checkConsentRequiredAction").build().get();
        }

        @ConditionalOnMissingBean(name={"confirmConsentAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action confirmConsentAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="consentEngine") ConsentEngine consentEngine, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new ConfirmConsentAction(servicesManager, authenticationRequestServiceSelectionStrategies, consentEngine, casProperties, attributeDefinitionStore, applicationContext)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("confirmConsentAction").build().get();
        }
    }
}

