/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.PageViewport;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.inline.AbstractPageNumberCitationLayoutManager;

public class PageNumberCitationLayoutManager
extends AbstractPageNumberCitationLayoutManager {
    public PageNumberCitationLayoutManager(PageNumberCitation node) {
        super(node);
    }

    public InlineArea get(LayoutContext context) {
        this.curArea = this.getPageNumberCitationInlineArea();
        return this.curArea;
    }

    private InlineArea getPageNumberCitationInlineArea() {
        PageViewport page = this.getPSLM().getFirstPVWithID(this.fobj.getRefId());
        TextArea text = null;
        int level = this.getBidiLevel();
        if (page != null) {
            String str = page.getPageNumberString();
            text = new TextArea();
            int width = this.getStringWidth(str);
            text.setBidiLevel(level);
            text.addWord(str, 0, level);
            text.setIPD(width);
            this.resolved = true;
        } else {
            text = new UnresolvedPageNumber(this.fobj.getRefId(), this.font);
            String str = "MMM";
            int width = this.getStringWidth(str);
            text.setBidiLevel(level);
            text.setIPD(width);
            this.resolved = false;
        }
        this.updateTextAreaTraits(text);
        return text;
    }
}

