/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.fop.fonts.EmbedFontInfo;

public class CachedFontInfo
extends EmbedFontInfo {
    private static final long serialVersionUID = 240028291961081894L;
    private long lastModified = -1L;

    public static File getFileFromUrls(String[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String urlStr = urls[i];
            if (urlStr == null) continue;
            File fontFile = null;
            if (urlStr.startsWith("file:")) {
                try {
                    URL url = new URL(urlStr);
                    fontFile = FileUtils.toFile((URL)url);
                }
                catch (MalformedURLException mfue) {
                    // empty catch block
                }
            }
            if (fontFile == null) {
                fontFile = new File(urlStr);
            }
            if (!fontFile.exists() || !fontFile.canRead()) continue;
            return fontFile;
        }
        return null;
    }

    public CachedFontInfo(String metricsFile, boolean kerning, List fontTriplets, String embedFile, long lastModified) {
        super(metricsFile, kerning, fontTriplets, embedFile);
        this.lastModified = lastModified;
    }

    public CachedFontInfo(EmbedFontInfo fontInfo) {
        super(fontInfo.metricsFile, fontInfo.kerning, fontInfo.fontTriplets, fontInfo.embedFile);
        File fontFile = CachedFontInfo.getFileFromUrls(new String[]{this.embedFile, this.metricsFile});
        if (fontFile != null) {
            this.lastModified = fontFile.lastModified();
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String toString() {
        return super.toString() + ", lastModified=" + this.lastModified;
    }
}

