/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.ColorUtil;

public final class ColorProperty
extends Property {
    private static final PropertyCache cache = new PropertyCache();
    protected final Color color;

    public static ColorProperty getInstance(FOUserAgent foUserAgent, String value) throws PropertyException {
        ColorProperty instance = new ColorProperty(ColorUtil.parseColorString(foUserAgent, value));
        return (ColorProperty)cache.fetch(instance);
    }

    public static ColorProperty getInstance(Color color) {
        return (ColorProperty)cache.fetch(new ColorProperty(color));
    }

    private ColorProperty(Color value) {
        this.color = value;
    }

    public Color getColor(FOUserAgent foUserAgent) {
        return this.color;
    }

    public String toString() {
        return ColorUtil.colorToString(this.color);
    }

    public ColorProperty getColorProperty() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ColorProperty) {
            return ((ColorProperty)o).color.equals(this.color);
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof ColorProperty) {
                return p;
            }
            FObj fobj = fo == null ? propertyList.getFObj() : fo;
            FOUserAgent ua = fobj == null ? null : fobj.getUserAgent();
            Color val = p.getColor(ua);
            if (val != null) {
                return new ColorProperty(val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

