/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.GaussianBlurRable8Bit;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeGaussianBlurElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feGaussianBlur";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        float[] fArray = SVGFeGaussianBlurElementBridge.convertStdDeviation(element, bridgeContext);
        if (fArray[0] < 0.0f || fArray[1] < 0.0f) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"stdDeviation", String.valueOf(fArray[0]) + fArray[1]});
        }
        Filter filter2 = SVGFeGaussianBlurElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter2, rectangle2D3, PadMode.ZERO_PAD);
        GaussianBlurRable8Bit gaussianBlurRable8Bit = new GaussianBlurRable8Bit((Filter)padRable8Bit, (double)fArray[0], (double)fArray[1]);
        SVGFeGaussianBlurElementBridge.handleColorInterpolationFilters((Filter)gaussianBlurRable8Bit, element);
        PadRable8Bit padRable8Bit2 = new PadRable8Bit((Filter)gaussianBlurRable8Bit, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeGaussianBlurElementBridge.updateFilterMap(element, (Filter)padRable8Bit2, map);
        return padRable8Bit2;
    }

    protected static float[] convertStdDeviation(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "stdDeviation");
        if (string.length() == 0) {
            return new float[]{0.0f, 0.0f};
        }
        float[] fArray = new float[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            fArray[0] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            fArray[1] = stringTokenizer.hasMoreTokens() ? SVGUtilities.convertSVGNumber(stringTokenizer.nextToken()) : fArray[0];
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"stdDeviation", string, numberFormatException});
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"stdDeviation", string});
        }
        return fArray;
    }
}

