/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ExecutionContext;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.Reference;

public class ArrayRecipe
extends AbstractRecipe {
    private final List<Object> list;
    private String typeName;
    private Class typeClass;
    private PropertyEditorRegistry registry;
    private final EnumSet<Option> options = EnumSet.noneOf(Option.class);

    public ArrayRecipe() {
        this.list = new ArrayList<Object>();
    }

    public ArrayRecipe(String type) {
        this.list = new ArrayList<Object>();
        this.typeName = type;
    }

    public ArrayRecipe(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.list = new ArrayList<Object>();
        this.typeClass = type;
    }

    public ArrayRecipe(ArrayRecipe collectionRecipe) {
        if (collectionRecipe == null) {
            throw new NullPointerException("setRecipe is null");
        }
        this.typeName = collectionRecipe.typeName;
        this.typeClass = collectionRecipe.typeClass;
        this.list = new ArrayList<Object>(collectionRecipe.list);
    }

    public void setRegistry(PropertyEditorRegistry registry) {
        this.registry = registry;
    }

    public void allow(Option option) {
        this.options.add(option);
    }

    public void disallow(Option option) {
        this.options.remove((Object)option);
    }

    @Override
    public List<Recipe> getNestedRecipes() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.list.size());
        for (Object o : this.list) {
            if (!(o instanceof Recipe)) continue;
            Recipe recipe = (Recipe)o;
            nestedRecipes.add(recipe);
        }
        return nestedRecipes;
    }

    @Override
    public List<Recipe> getConstructorRecipes() {
        if (!this.options.contains((Object)Option.LAZY_ASSIGNMENT)) {
            return this.getNestedRecipes();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canCreate(Type expectedType) {
        Class expectedClass = RecipeHelper.toClass(expectedType);
        Class myType = this.getType(expectedType);
        return expectedClass.isArray() && RecipeHelper.isAssignable(expectedClass.getComponentType(), myType);
    }

    @Override
    protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        Object array;
        Class type = this.getType(expectedType);
        try {
            array = Array.newInstance(type, this.list.size());
        }
        catch (Exception e) {
            throw new ConstructionException("Error while creating array instance: " + type.getName());
        }
        if (this.getName() != null) {
            ExecutionContext.getContext().addObject(this.getName(), array);
        }
        boolean refAllowed = this.options.contains((Object)Option.LAZY_ASSIGNMENT);
        int index = 0;
        for (Object value : this.list) {
            if ((value = RecipeHelper.convert(type, value, refAllowed, this.registry)) instanceof Reference) {
                Reference reference = (Reference)value;
                reference.setAction(new UpdateArray(array, index));
            } else {
                Array.set(array, index, value);
            }
            ++index;
        }
        return array;
    }

    private Class getType(Type expectedType) {
        Class expectedClass = RecipeHelper.toClass(expectedType);
        if (expectedClass.isArray()) {
            expectedClass = expectedClass.getComponentType();
        }
        Class type = expectedClass;
        if (this.typeClass != null || this.typeName != null) {
            type = this.typeClass;
            if (type == null) {
                try {
                    type = RecipeHelper.loadClass(this.typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConstructionException("Type class could not be found: " + this.typeName);
                }
            }
            if (type.isAssignableFrom(expectedClass)) {
                type = expectedClass;
            }
        }
        return type;
    }

    public void add(Object value) {
        this.list.add(value);
    }

    public void addAll(Collection<?> value) {
        this.list.addAll(value);
    }

    public void remove(Object value) {
        this.list.remove(value);
    }

    public void removeAll(Object value) {
        this.list.remove(value);
    }

    public List<Object> getAll() {
        return Collections.unmodifiableList(this.list);
    }

    private static class UpdateArray
    implements Reference.Action {
        private final Object array;
        private final int index;

        public UpdateArray(Object array, int index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public void onSet(Reference ref) {
            Array.set(this.array, this.index, ref.get());
        }
    }
}

