/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.input;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import org.apache.commons.codec.binary.Base64;
import org.apache.wss4j.binding.wss10.SecurityTokenReferenceType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.impl.processor.input.OperationInputProcessor;
import org.apache.wss4j.stax.impl.processor.input.WSSEncryptedKeyInputHandler;
import org.apache.wss4j.stax.securityEvent.SamlTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.SignedPartSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityToken.SamlSecurityToken;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.wss4j.stax.validate.SamlTokenValidator;
import org.apache.wss4j.stax.validate.SamlTokenValidatorImpl;
import org.apache.wss4j.stax.validate.TokenContext;
import org.apache.xml.security.binding.xmldsig.KeyInfoType;
import org.apache.xml.security.binding.xmldsig.KeyValueType;
import org.apache.xml.security.binding.xmldsig.ObjectFactory;
import org.apache.xml.security.binding.xmldsig.X509DataType;
import org.apache.xml.security.binding.xmlenc.EncryptedKeyType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.JCEAlgorithmMapper;
import org.apache.xml.security.stax.ext.AbstractInputProcessor;
import org.apache.xml.security.stax.ext.AbstractInputSecurityHeaderHandler;
import org.apache.xml.security.stax.ext.InputProcessor;
import org.apache.xml.security.stax.ext.InputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecNamespace;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.XMLSecurityEventReader;
import org.apache.xml.security.stax.impl.securityToken.AbstractInboundSecurityToken;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.apache.xml.security.stax.securityEvent.SignedElementSecurityEvent;
import org.apache.xml.security.stax.securityToken.InboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;
import org.apache.xml.security.stax.securityToken.SecurityTokenFactory;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class SAMLTokenInputHandler
extends AbstractInputSecurityHeaderHandler {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final List<QName> saml1TokenPath = new ArrayList<QName>(WSSConstants.WSSE_SECURITY_HEADER_PATH);
    private static final List<QName> saml2TokenPath = new ArrayList<QName>(WSSConstants.WSSE_SECURITY_HEADER_PATH);

    public void handle(InputProcessorChain inputProcessorChain, XMLSecurityProperties securityProperties, Deque<XMLSecEvent> eventQueue, Integer index) throws XMLSecurityException {
        Object subjectSecurityToken;
        Document samlTokenDocument = (Document)this.parseStructure(eventQueue, index, securityProperties);
        WSSSecurityProperties wssSecurityProperties = (WSSSecurityProperties)securityProperties;
        WSInboundSecurityContext wsInboundSecurityContext = (WSInboundSecurityContext)inputProcessorChain.getSecurityContext();
        Element samlElement = samlTokenDocument.getDocumentElement();
        final SamlAssertionWrapper samlAssertionWrapper = new SamlAssertionWrapper(samlElement);
        SamlTokenValidator samlTokenValidator = (SamlTokenValidator)wssSecurityProperties.getValidator(new QName(samlElement.getNamespaceURI(), samlElement.getLocalName()));
        if (samlTokenValidator == null) {
            samlTokenValidator = new SamlTokenValidatorImpl();
        }
        if (samlAssertionWrapper.isSigned()) {
            Signature signature = samlAssertionWrapper.getSignature();
            if (signature == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "empty", new Object[]{"no signature to validate"});
            }
            int sigKeyInfoIdx = this.getSignatureKeyInfoIndex(eventQueue);
            if (sigKeyInfoIdx < 0) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "noKeyInSAMLToken");
            }
            InboundSecurityToken sigSecurityToken = this.parseKeyInfo(inputProcessorChain, securityProperties, eventQueue, sigKeyInfoIdx);
            if (sigSecurityToken == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "noKeyInSAMLToken");
            }
            samlTokenValidator.validate(sigSecurityToken, wssSecurityProperties);
            BasicX509Credential credential = null;
            if (sigSecurityToken.getX509Certificates() != null) {
                credential = new BasicX509Credential(sigSecurityToken.getX509Certificates()[0]);
            } else if (sigSecurityToken.getPublicKey() != null) {
                credential = new BasicCredential(sigSecurityToken.getPublicKey());
            } else {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
            }
            try {
                SignatureValidator.validate((Signature)signature, (Credential)credential);
            }
            catch (SignatureException ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)ex), "empty", new Object[]{"SAML signature validation failed"});
            }
        }
        List methods = samlAssertionWrapper.getConfirmationMethods();
        boolean holderOfKey = false;
        if (methods != null) {
            for (String method : methods) {
                if (!OpenSAMLUtil.isMethodHolderOfKey((String)method)) continue;
                holderOfKey = true;
                break;
            }
        }
        if (holderOfKey) {
            final byte[] subjectSecretKey = SAMLUtil.getSecretKeyFromCallbackHandler((String)samlAssertionWrapper.getId(), (CallbackHandler)wssSecurityProperties.getCallbackHandler());
            if (subjectSecretKey != null && subjectSecretKey.length > 0) {
                subjectSecurityToken = new AbstractInboundSecurityToken(wsInboundSecurityContext, IDGenerator.generateID(null), WSSecurityTokenConstants.KeyIdentifier_NoKeyInfo, true){

                    public SecurityTokenConstants.TokenType getTokenType() {
                        return WSSecurityTokenConstants.DefaultToken;
                    }

                    public boolean isAsymmetric() throws XMLSecurityException {
                        return false;
                    }

                    protected Key getKey(String algorithmURI, XMLSecurityConstants.AlgorithmUsage algorithmUsage, String correlationID) throws XMLSecurityException {
                        Key key = super.getKey(algorithmURI, algorithmUsage, correlationID);
                        if (key == null) {
                            String algoFamily = JCEAlgorithmMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                            key = new SecretKeySpec(subjectSecretKey, algoFamily);
                            this.setSecretKey(algorithmURI, key);
                        }
                        return key;
                    }
                };
            } else {
                int subjectKeyInfoIndex = this.getSubjectKeyInfoIndex(eventQueue);
                if (subjectKeyInfoIndex < 0) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "noKeyInSAMLToken");
                }
                subjectSecurityToken = this.parseKeyInfo(inputProcessorChain, securityProperties, eventQueue, subjectKeyInfoIndex);
                if (subjectSecurityToken == null) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "noKeyInSAMLToken");
                }
            }
        } else {
            subjectSecurityToken = null;
        }
        List xmlSecEvents = this.getResponsibleXMLSecEvents(eventQueue, index);
        List elementPath = this.getElementPath(eventQueue);
        TokenContext tokenContext = new TokenContext(wssSecurityProperties, wsInboundSecurityContext, xmlSecEvents, elementPath);
        final Object samlSecurityToken = samlTokenValidator.validate(samlAssertionWrapper, (InboundSecurityToken)subjectSecurityToken, tokenContext);
        SecurityTokenProvider<InboundSecurityToken> subjectSecurityTokenProvider = new SecurityTokenProvider<InboundSecurityToken>(){

            public InboundSecurityToken getSecurityToken() throws XMLSecurityException {
                return (InboundSecurityToken)samlSecurityToken;
            }

            public String getId() {
                return samlAssertionWrapper.getId();
            }
        };
        wsInboundSecurityContext.registerSecurityTokenProvider(samlAssertionWrapper.getId(), (SecurityTokenProvider)subjectSecurityTokenProvider);
        SamlTokenSecurityEvent samlTokenSecurityEvent = new SamlTokenSecurityEvent();
        samlTokenSecurityEvent.setSecurityToken((SamlSecurityToken)subjectSecurityTokenProvider.getSecurityToken());
        samlTokenSecurityEvent.setCorrelationID(samlAssertionWrapper.getId());
        wsInboundSecurityContext.registerSecurityEvent((SecurityEvent)samlTokenSecurityEvent);
        if (wssSecurityProperties.isValidateSamlSubjectConfirmation()) {
            SAMLTokenVerifierInputProcessor samlTokenVerifierInputProcessor = new SAMLTokenVerifierInputProcessor(securityProperties, samlAssertionWrapper, subjectSecurityTokenProvider, (InboundSecurityToken)subjectSecurityToken);
            wsInboundSecurityContext.addSecurityEventListener(samlTokenVerifierInputProcessor);
            inputProcessorChain.addProcessor((InputProcessor)samlTokenVerifierInputProcessor);
        }
    }

    private int getSubjectKeyInfoIndex(Deque<XMLSecEvent> eventQueue) {
        int idx = -1;
        Iterator<XMLSecEvent> xmlSecEventIterator = eventQueue.descendingIterator();
        while (xmlSecEventIterator.hasNext()) {
            XMLSecEvent xmlSecEvent = xmlSecEventIterator.next();
            ++idx;
            switch (xmlSecEvent.getEventType()) {
                case 1: {
                    List elementPath;
                    QName elementName = xmlSecEvent.asStartElement().getName();
                    if (!WSSConstants.TAG_dsig_KeyInfo.equals(elementName) || (elementPath = xmlSecEvent.asStartElement().getElementPath()).size() < 4) break;
                    int lastIndex = elementPath.size() - 2;
                    if ("SubjectConfirmationData".equals(((QName)elementPath.get(lastIndex)).getLocalPart()) && "SubjectConfirmation".equals(((QName)elementPath.get(lastIndex - 1)).getLocalPart()) && "Subject".equals(((QName)elementPath.get(lastIndex - 2)).getLocalPart())) {
                        return idx;
                    }
                    if (!"SubjectConfirmation".equals(((QName)elementPath.get(lastIndex)).getLocalPart()) || !"Subject".equals(((QName)elementPath.get(lastIndex - 1)).getLocalPart())) break;
                    return idx;
                }
            }
        }
        return idx;
    }

    private int getSignatureKeyInfoIndex(Deque<XMLSecEvent> eventQueue) {
        int idx = -1;
        Iterator<XMLSecEvent> xmlSecEventIterator = eventQueue.descendingIterator();
        while (xmlSecEventIterator.hasNext()) {
            XMLSecEvent xmlSecEvent = xmlSecEventIterator.next();
            ++idx;
            switch (xmlSecEvent.getEventType()) {
                case 1: {
                    int lastIndex;
                    List elementPath;
                    QName elementName = xmlSecEvent.asStartElement().getName();
                    if (!WSSConstants.TAG_dsig_KeyInfo.equals(elementName) || (elementPath = xmlSecEvent.asStartElement().getElementPath()).size() < 4 || !"Signature".equals(((QName)elementPath.get(lastIndex = elementPath.size() - 2)).getLocalPart()) || !"Assertion".equals(((QName)elementPath.get(lastIndex - 1)).getLocalPart())) break;
                    return idx;
                }
            }
        }
        return idx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InboundSecurityToken parseKeyInfo(InputProcessorChain inputProcessorChain, XMLSecurityProperties securityProperties, Deque<XMLSecEvent> eventQueue, int index) throws XMLSecurityException {
        int idx;
        XMLSecEvent xmlSecEvent = null;
        Iterator<XMLSecEvent> xmlSecEventIterator = eventQueue.descendingIterator();
        for (idx = 0; xmlSecEventIterator.hasNext() && idx <= index; ++idx) {
            xmlSecEvent = xmlSecEventIterator.next();
        }
        while (xmlSecEventIterator.hasNext() && !(xmlSecEvent = xmlSecEventIterator.next()).isStartElement()) {
            ++idx;
        }
        if (xmlSecEvent == null) throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "noKeyInSAMLToken");
        if (!xmlSecEvent.isStartElement()) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "noKeyInSAMLToken");
        }
        XMLSecStartElement xmlSecStartElement = xmlSecEvent.asStartElement();
        QName elementName = xmlSecStartElement.getName();
        if (!WSSConstants.TAG_wst_BinarySecret.equals(elementName) && !WSSConstants.TAG_wst0512_BinarySecret.equals(elementName)) {
            Object object = null;
            try {
                Unmarshaller unmarshaller = WSSConstants.getJaxbUnmarshaller((boolean)securityProperties.isDisableSchemaValidation());
                object = unmarshaller.unmarshal((XMLEventReader)new XMLSecurityEventReader(eventQueue, idx));
            }
            catch (JAXBException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_SECURITY_TOKEN, (Exception)((Object)e));
            }
            if (object instanceof JAXBElement) {
                object = ((JAXBElement)object).getValue();
            }
            KeyInfoType keyInfoType = null;
            if (object instanceof X509DataType) {
                JAXBElement x509DataTypeJAXBElement = new ObjectFactory().createX509Data((X509DataType)object);
                keyInfoType = new KeyInfoType();
                SecurityTokenReferenceType securityTokenReferenceType = new SecurityTokenReferenceType();
                securityTokenReferenceType.getAny().add(x509DataTypeJAXBElement);
                JAXBElement securityTokenReferenceTypeJAXBElement = new org.apache.wss4j.binding.wss10.ObjectFactory().createSecurityTokenReference(securityTokenReferenceType);
                keyInfoType.getContent().add(securityTokenReferenceTypeJAXBElement);
                return SecurityTokenFactory.getInstance().getSecurityToken(keyInfoType, WSSecurityTokenConstants.KeyUsage_Signature_Verification, securityProperties, inputProcessorChain.getSecurityContext());
            }
            if (object instanceof EncryptedKeyType) {
                EncryptedKeyType encryptedKeyType = (EncryptedKeyType)object;
                WSSEncryptedKeyInputHandler encryptedKeyInputHandler = new WSSEncryptedKeyInputHandler();
                encryptedKeyInputHandler.handle(inputProcessorChain, encryptedKeyType, (XMLSecEvent)xmlSecStartElement, securityProperties);
                SecurityTokenProvider securityTokenProvider = inputProcessorChain.getSecurityContext().getSecurityTokenProvider(encryptedKeyType.getId());
                if (securityTokenProvider == null) return SecurityTokenFactory.getInstance().getSecurityToken(keyInfoType, WSSecurityTokenConstants.KeyUsage_Signature_Verification, securityProperties, inputProcessorChain.getSecurityContext());
                return (InboundSecurityToken)securityTokenProvider.getSecurityToken();
            }
            if (object instanceof SecurityTokenReferenceType) {
                JAXBElement securityTokenReferenceTypeJAXBElement = new org.apache.wss4j.binding.wss10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)object);
                keyInfoType = new KeyInfoType();
                keyInfoType.getContent().add(securityTokenReferenceTypeJAXBElement);
                return SecurityTokenFactory.getInstance().getSecurityToken(keyInfoType, WSSecurityTokenConstants.KeyUsage_Signature_Verification, securityProperties, inputProcessorChain.getSecurityContext());
            }
            if (!(object instanceof KeyValueType)) throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_SECURITY_TOKEN, "unsupportedKeyInfo");
            JAXBElement keyValueTypeJAXBElement = new ObjectFactory().createKeyValue((KeyValueType)object);
            keyInfoType = new KeyInfoType();
            keyInfoType.getContent().add(keyValueTypeJAXBElement);
            return SecurityTokenFactory.getInstance().getSecurityToken(keyInfoType, WSSecurityTokenConstants.KeyUsage_Signature_Verification, securityProperties, inputProcessorChain.getSecurityContext());
        }
        final StringBuilder stringBuilder = new StringBuilder();
        while (xmlSecEventIterator.hasNext()) {
            xmlSecEvent = xmlSecEventIterator.next();
            switch (xmlSecEvent.getEventType()) {
                case 2: {
                    if (!xmlSecEvent.asEndElement().getName().equals(elementName)) break;
                    return new AbstractInboundSecurityToken(inputProcessorChain.getSecurityContext(), IDGenerator.generateID(null), WSSecurityTokenConstants.KeyIdentifier_NoKeyInfo, true){

                        public SecurityTokenConstants.TokenType getTokenType() {
                            return WSSecurityTokenConstants.DefaultToken;
                        }

                        public boolean isAsymmetric() throws XMLSecurityException {
                            return false;
                        }

                        protected Key getKey(String algorithmURI, XMLSecurityConstants.AlgorithmUsage algorithmUsage, String correlationID) throws XMLSecurityException {
                            Key key = super.getKey(algorithmURI, algorithmUsage, correlationID);
                            if (key == null) {
                                String algoFamily = JCEAlgorithmMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                                key = new SecretKeySpec(Base64.decodeBase64((String)stringBuilder.toString()), algoFamily);
                                this.setSecretKey(algorithmURI, key);
                            }
                            return key;
                        }
                    };
                }
                case 4: {
                    stringBuilder.append(xmlSecEvent.asCharacters().getText());
                }
            }
        }
        return new /* invalid duplicate definition of identical inner class */;
    }

    protected <T> T parseStructure(Deque<XMLSecEvent> eventDeque, int index, XMLSecurityProperties securityProperties) throws XMLSecurityException {
        Document document;
        try {
            document = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, (Exception)e);
        }
        Iterator<XMLSecEvent> xmlSecEventIterator = eventDeque.descendingIterator();
        int curIdx = 0;
        while (curIdx++ < index) {
            xmlSecEventIterator.next();
        }
        Node currentNode = document;
        while (xmlSecEventIterator.hasNext()) {
            XMLSecEvent next = xmlSecEventIterator.next();
            currentNode = this.parseXMLEvent(next, currentNode, document);
        }
        return (T)document;
    }

    public Node parseXMLEvent(XMLSecEvent xmlSecEvent, Node currentNode, Document document) throws WSSecurityException {
        switch (xmlSecEvent.getEventType()) {
            case 1: {
                XMLSecStartElement xmlSecStartElement = xmlSecEvent.asStartElement();
                Element element = document.createElementNS(xmlSecStartElement.getName().getNamespaceURI(), xmlSecStartElement.getName().getLocalPart());
                if (xmlSecStartElement.getName().getPrefix() != null && !xmlSecStartElement.getName().getPrefix().isEmpty()) {
                    element.setPrefix(xmlSecStartElement.getName().getPrefix());
                }
                currentNode = currentNode.appendChild(element);
                Iterator namespaceIterator = xmlSecStartElement.getNamespaces();
                while (namespaceIterator.hasNext()) {
                    XMLSecNamespace next = (XMLSecNamespace)namespaceIterator.next();
                    this.parseXMLEvent((XMLSecEvent)next, currentNode, document);
                }
                Iterator attributesIterator = xmlSecStartElement.getAttributes();
                while (attributesIterator.hasNext()) {
                    XMLSecAttribute next = (XMLSecAttribute)attributesIterator.next();
                    this.parseXMLEvent((XMLSecEvent)next, currentNode, document);
                }
                String elementNs = document.lookupNamespaceURI(xmlSecStartElement.getName().getPrefix());
                if (elementNs != null) break;
                this.parseXMLEvent((XMLSecEvent)xmlSecStartElement.getElementNamespace(), currentNode, document);
                break;
            }
            case 2: {
                if (currentNode.getParentNode() == null) break;
                currentNode = currentNode.getParentNode();
                break;
            }
            case 3: {
                ProcessingInstruction piNode = document.createProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)xmlSecEvent).getTarget(), ((javax.xml.stream.events.ProcessingInstruction)xmlSecEvent).getTarget());
                currentNode.appendChild(piNode);
                break;
            }
            case 4: {
                Text characterNode = document.createTextNode(xmlSecEvent.asCharacters().getData());
                currentNode.appendChild(characterNode);
                break;
            }
            case 5: {
                Comment commentNode = document.createComment(((javax.xml.stream.events.Comment)xmlSecEvent).getText());
                currentNode.appendChild(commentNode);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                return currentNode;
            }
            case 10: {
                XMLSecAttribute xmlSecAttribute = (XMLSecAttribute)xmlSecEvent;
                Attr attributeNode = document.createAttributeNS(xmlSecAttribute.getName().getNamespaceURI(), xmlSecAttribute.getName().getLocalPart());
                attributeNode.setPrefix(xmlSecAttribute.getName().getPrefix());
                attributeNode.setValue(xmlSecAttribute.getValue());
                ((Element)currentNode).setAttributeNodeNS(attributeNode);
                String attrNs = document.lookupNamespaceURI(xmlSecAttribute.getName().getPrefix());
                if (attrNs != null) break;
                this.parseXMLEvent((XMLSecEvent)xmlSecAttribute.getAttributeNamespace(), currentNode, document);
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xmlSecEvent;
                String prefix = namespace.getPrefix();
                Attr namespaceNode = prefix == null || prefix.isEmpty() ? document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns") : document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix);
                namespaceNode.setValue(namespace.getNamespaceURI());
                ((Element)currentNode).setAttributeNodeNS(namespaceNode);
                break;
            }
            default: {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "empty", new Object[]{"Illegal XMLEvent received: " + xmlSecEvent.getEventType()});
            }
        }
        return currentNode;
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        saml1TokenPath.add(WSSConstants.TAG_saml_Assertion);
        saml2TokenPath.add(WSSConstants.TAG_saml2_Assertion);
    }

    class SAMLTokenVerifierInputProcessor
    extends AbstractInputProcessor
    implements SecurityEventListener {
        private SamlAssertionWrapper samlAssertionWrapper;
        private SecurityTokenProvider<InboundSecurityToken> securityTokenProvider;
        private InboundSecurityToken subjectSecurityToken;
        private List<SignedElementSecurityEvent> samlTokenSignedElementSecurityEvents;
        private SignedPartSecurityEvent bodySignedPartSecurityEvent;

        SAMLTokenVerifierInputProcessor(XMLSecurityProperties securityProperties, SamlAssertionWrapper samlAssertionWrapper, SecurityTokenProvider<InboundSecurityToken> securityTokenProvider, InboundSecurityToken subjectSecurityToken) {
            super(securityProperties);
            this.samlTokenSignedElementSecurityEvents = new ArrayList<SignedElementSecurityEvent>();
            this.setPhase(XMLSecurityConstants.Phase.POSTPROCESSING);
            this.addAfterProcessor(OperationInputProcessor.class.getName());
            this.samlAssertionWrapper = samlAssertionWrapper;
            this.securityTokenProvider = securityTokenProvider;
            this.subjectSecurityToken = subjectSecurityToken;
        }

        public void registerSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
            SignedElementSecurityEvent signedPartSecurityEvent;
            List elementPath;
            if (WSSecurityEventConstants.SignedPart.equals((Object)securityEvent.getSecurityEventType())) {
                SignedPartSecurityEvent signedPartSecurityEvent2 = (SignedPartSecurityEvent)securityEvent;
                List elementPath2 = signedPartSecurityEvent2.getElementPath();
                if (elementPath2.equals(WSSConstants.SOAP_11_BODY_PATH)) {
                    this.bodySignedPartSecurityEvent = signedPartSecurityEvent2;
                }
            } else if (WSSecurityEventConstants.SignedElement.equals((Object)securityEvent.getSecurityEventType()) && ((elementPath = (signedPartSecurityEvent = (SignedElementSecurityEvent)securityEvent).getElementPath()).equals(saml2TokenPath) || elementPath.equals(saml1TokenPath))) {
                this.samlTokenSignedElementSecurityEvents.add(signedPartSecurityEvent);
            }
        }

        public XMLSecEvent processNextHeaderEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
            return inputProcessorChain.processHeaderEvent();
        }

        public XMLSecEvent processNextEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
            XMLSecStartElement xmlSecStartElement;
            List elementPath;
            XMLSecEvent xmlSecEvent = inputProcessorChain.processEvent();
            if (xmlSecEvent.getEventType() == 1 && (elementPath = (xmlSecStartElement = xmlSecEvent.asStartElement()).getElementPath()).size() == 3 && WSSUtils.isInSOAPBody(elementPath)) {
                inputProcessorChain.removeProcessor((InputProcessor)this);
                this.checkPossessionOfKey(inputProcessorChain, this.samlAssertionWrapper, this.subjectSecurityToken);
            }
            return xmlSecEvent;
        }

        private void checkPossessionOfKey(InputProcessorChain inputProcessorChain, SamlAssertionWrapper samlAssertionWrapper, InboundSecurityToken subjectSecurityToken) throws WSSecurityException {
            boolean methodNotSatisfied = false;
            try {
                SecurityToken httpsSecurityToken = this.getHttpsSecurityToken(inputProcessorChain);
                List securityTokenProviders = inputProcessorChain.getSecurityContext().getRegisteredSecurityTokenProviders();
                List confirmationMethods = samlAssertionWrapper.getConfirmationMethods();
                for (int i = 0; i < confirmationMethods.size(); ++i) {
                    String confirmationMethod = (String)confirmationMethods.get(i);
                    if (OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) {
                        X509Certificate[] subjectCertificates = subjectSecurityToken.getX509Certificates();
                        PublicKey subjectPublicKey = subjectSecurityToken.getPublicKey();
                        Key subjectSecretKey = null;
                        Map subjectKeyMap = subjectSecurityToken.getSecretKey();
                        if (subjectKeyMap.size() > 0) {
                            subjectSecretKey = subjectKeyMap.values().toArray(new Key[subjectKeyMap.size()])[0];
                        }
                        if (httpsSecurityToken != null && httpsSecurityToken.getX509Certificates() != null && httpsSecurityToken.getX509Certificates().length > 0) {
                            X509Certificate httpsCertificate = httpsSecurityToken.getX509Certificates()[0];
                            if (subjectCertificates != null && subjectCertificates.length > 0 && httpsCertificate.equals(subjectCertificates[0])) {
                                return;
                            }
                            if (httpsCertificate.getPublicKey().equals(subjectPublicKey)) {
                                return;
                            }
                        }
                        for (int j = 0; j < securityTokenProviders.size(); ++j) {
                            SecurityTokenProvider securityTokenProvider = (SecurityTokenProvider)securityTokenProviders.get(j);
                            InboundSecurityToken securityToken = (InboundSecurityToken)securityTokenProvider.getSecurityToken();
                            if (securityToken == httpsSecurityToken || securityToken == subjectSecurityToken || !securityToken.getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_MainSignature) && !securityToken.getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_Signature) && !securityToken.getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_EndorsingEncryptedSupportingTokens) && !securityToken.getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_EndorsingSupportingTokens) && !securityToken.getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_SignedEndorsingEncryptedSupportingTokens) && !securityToken.getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_SignedEndorsingSupportingTokens)) continue;
                            X509Certificate[] x509Certificates = securityToken.getX509Certificates();
                            PublicKey publicKey = securityToken.getPublicKey();
                            Map keyMap = securityToken.getSecretKey();
                            if (x509Certificates != null && x509Certificates.length > 0 && subjectCertificates != null && subjectCertificates.length > 0 && subjectCertificates[0].equals(x509Certificates[0])) {
                                return;
                            }
                            if (publicKey != null && publicKey.equals(subjectPublicKey)) {
                                return;
                            }
                            for (Map.Entry next : keyMap.entrySet()) {
                                if (!((Key)next.getValue()).equals(subjectSecretKey)) continue;
                                return;
                            }
                        }
                        methodNotSatisfied = true;
                        continue;
                    }
                    if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) continue;
                    if (httpsSecurityToken != null && httpsSecurityToken.getX509Certificates() != null && httpsSecurityToken.getX509Certificates().length > 0) {
                        return;
                    }
                    SignedElementSecurityEvent samlTokenSignedElementSecurityEvent = null;
                    for (int j = 0; j < this.samlTokenSignedElementSecurityEvents.size(); ++j) {
                        SignedElementSecurityEvent signedElementSecurityEvent = this.samlTokenSignedElementSecurityEvents.get(j);
                        if (((InboundSecurityToken)this.securityTokenProvider.getSecurityToken()).getXMLSecEvent() != signedElementSecurityEvent.getXmlSecEvent()) continue;
                        samlTokenSignedElementSecurityEvent = signedElementSecurityEvent;
                    }
                    if (this.bodySignedPartSecurityEvent != null && samlTokenSignedElementSecurityEvent != null && this.bodySignedPartSecurityEvent.getSecurityToken() == samlTokenSignedElementSecurityEvent.getSecurityToken()) {
                        return;
                    }
                    methodNotSatisfied = true;
                }
            }
            catch (XMLSecurityException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)e));
            }
            if (methodNotSatisfied) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "empty", new Object[]{"SAML proof-of-possession of the private/secret key failed"});
            }
        }

        private SecurityToken getHttpsSecurityToken(InputProcessorChain inputProcessorChain) throws XMLSecurityException {
            List securityTokenProviders = inputProcessorChain.getSecurityContext().getRegisteredSecurityTokenProviders();
            for (int i = 0; i < securityTokenProviders.size(); ++i) {
                SecurityTokenProvider securityTokenProvider = (SecurityTokenProvider)securityTokenProviders.get(i);
                SecurityToken securityToken = (SecurityToken)securityTokenProvider.getSecurityToken();
                if (!WSSecurityTokenConstants.HttpsToken.equals((Object)securityToken.getTokenType())) continue;
                return securityToken;
            }
            return null;
        }
    }
}

