/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.truth.xml.CoalescingFilter;
import org.apache.axiom.truth.xml.Event;
import org.apache.axiom.truth.xml.Filter;
import org.apache.axiom.truth.xml.RedundantNamespaceDeclarationFilter;
import org.apache.axiom.truth.xml.Traverser;
import org.apache.axiom.truth.xml.TraverserException;
import org.apache.axiom.truth.xml.XML;

public final class XMLSubject
extends Subject<XMLSubject, XML> {
    private final Set<Event> ignoredEvents = new HashSet<Event>();
    private boolean ignoreWhitespace;
    private boolean ignoreWhitespaceInPrologAndEpilog;
    private boolean ignorePrologAndEpilog;
    private boolean ignoreNamespaceDeclarations;
    private boolean ignoreNamespacePrefixes;
    private boolean ignoreRedundantNamespaceDeclarations;
    private boolean expandEntityReferences;
    private boolean treatWhitespaceAsText;

    XMLSubject(FailureStrategy failureStrategy, XML subject) {
        super(failureStrategy, (Object)subject);
    }

    public XMLSubject ignoringComments() {
        this.ignoredEvents.add(Event.COMMENT);
        return this;
    }

    public XMLSubject ignoringElementContentWhitespace() {
        this.ignoredEvents.add(Event.WHITESPACE);
        return this;
    }

    public XMLSubject ignoringWhitespace() {
        this.ignoredEvents.add(Event.WHITESPACE);
        this.ignoreWhitespace = true;
        return this;
    }

    public XMLSubject ignoringWhitespaceInPrologAndEpilog() {
        this.ignoreWhitespaceInPrologAndEpilog = true;
        return this;
    }

    public XMLSubject ignoringPrologAndEpilog() {
        this.ignorePrologAndEpilog = true;
        return this;
    }

    public XMLSubject ignoringNamespaceDeclarations() {
        this.ignoreNamespaceDeclarations = true;
        return this;
    }

    public XMLSubject ignoringNamespacePrefixes() {
        this.ignoreNamespacePrefixes = true;
        return this;
    }

    public XMLSubject ignoringRedundantNamespaceDeclarations() {
        this.ignoreRedundantNamespaceDeclarations = true;
        return this;
    }

    public XMLSubject expandingEntityReferences() {
        return this.expandingEntityReferences(true);
    }

    public XMLSubject expandingEntityReferences(boolean value) {
        this.expandEntityReferences = value;
        return this;
    }

    public XMLSubject treatingElementContentWhitespaceAsText() {
        this.treatWhitespaceAsText = true;
        return this;
    }

    private Traverser createTraverser(XML xml) throws TraverserException {
        Traverser traverser = xml.createTraverser(this.expandEntityReferences);
        if (this.ignoreWhitespaceInPrologAndEpilog || this.ignorePrologAndEpilog) {
            final boolean onlyWhitespace = !this.ignorePrologAndEpilog;
            traverser = new Filter(traverser){
                private int depth;

                @Override
                public Event next() throws TraverserException {
                    Event event;
                    block5: while ((event = super.next()) != null) {
                        switch (event) {
                            case START_ELEMENT: {
                                ++this.depth;
                                break block5;
                            }
                            case END_ELEMENT: {
                                --this.depth;
                                break block5;
                            }
                            default: {
                                if (onlyWhitespace) break block5;
                            }
                            case WHITESPACE: {
                                if (this.depth == 0) continue block5;
                            }
                        }
                    }
                    return event;
                }
            };
        }
        if (!this.ignoredEvents.isEmpty()) {
            traverser = new Filter(traverser){

                @Override
                public Event next() throws TraverserException {
                    Event event;
                    do {
                        event = super.next();
                    } while (XMLSubject.this.ignoredEvents.contains((Object)event));
                    return event;
                }
            };
        }
        traverser = new CoalescingFilter(traverser);
        if (this.ignoreWhitespace) {
            traverser = new Filter(traverser){

                @Override
                public Event next() throws TraverserException {
                    Event event = super.next();
                    if (event == Event.TEXT) {
                        String text = this.getText();
                        for (int i = 0; i < text.length(); ++i) {
                            if (" \r\n\t".indexOf(text.charAt(i)) != -1) continue;
                            return Event.TEXT;
                        }
                        return super.next();
                    }
                    return event;
                }
            };
        }
        if (this.treatWhitespaceAsText) {
            traverser = new Filter(traverser){

                @Override
                public Event next() throws TraverserException {
                    Event event = super.next();
                    return event == Event.WHITESPACE ? Event.TEXT : event;
                }
            };
        }
        if (this.ignoreRedundantNamespaceDeclarations && !this.ignoreNamespaceDeclarations) {
            traverser = new RedundantNamespaceDeclarationFilter(traverser);
        }
        return traverser;
    }

    private static Map<QName, String> extractPrefixes(Set<QName> qnames) {
        HashMap<QName, String> result = new HashMap<QName, String>();
        for (QName qname : qnames) {
            result.put(qname, qname.getPrefix());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void hasSameContentAs(XML other) {
        try {
            Traverser actual = this.createTraverser((XML)this.getSubject());
            Traverser expected = this.createTraverser(other);
            block10: while (true) {
                Event actualEvent = actual.next();
                Event expectedEvent = expected.next();
                Truth.assertThat((Comparable)((Object)actualEvent)).isEqualTo((Object)expectedEvent);
                if (expectedEvent == null) return;
                switch (expectedEvent) {
                    case DOCUMENT_TYPE: {
                        Truth.assertThat((String)actual.getRootName()).isEqualTo((Object)expected.getRootName());
                        Truth.assertThat((String)actual.getPublicId()).isEqualTo((Object)expected.getPublicId());
                        Truth.assertThat((String)actual.getSystemId()).isEqualTo((Object)expected.getSystemId());
                        continue block10;
                    }
                    case START_ELEMENT: {
                        QName actualQName = actual.getQName();
                        Map<QName, String> actualAttributes = actual.getAttributes();
                        QName expectedQName = expected.getQName();
                        Map<QName, String> expectedAttributes = expected.getAttributes();
                        Truth.assertThat((Object)actualQName).isEqualTo((Object)expectedQName);
                        Truth.assertThat(actualAttributes).isEqualTo(expectedAttributes);
                        if (!this.ignoreNamespacePrefixes) {
                            Truth.assertThat((String)actualQName.getPrefix()).isEqualTo((Object)expectedQName.getPrefix());
                            if (expectedAttributes != null) {
                                Truth.assertThat(XMLSubject.extractPrefixes(actualAttributes.keySet())).isEqualTo(XMLSubject.extractPrefixes(expectedAttributes.keySet()));
                            }
                        }
                        if (this.ignoreNamespaceDeclarations) continue block10;
                        Truth.assertThat(actual.getNamespaces()).isEqualTo(expected.getNamespaces());
                        continue block10;
                    }
                    case END_ELEMENT: {
                        continue block10;
                    }
                    case WHITESPACE: 
                    case TEXT: 
                    case COMMENT: 
                    case CDATA_SECTION: {
                        Truth.assertThat((String)actual.getText()).isEqualTo((Object)expected.getText());
                        continue block10;
                    }
                    case ENTITY_REFERENCE: {
                        if (this.expandEntityReferences) {
                            throw new IllegalStateException();
                        }
                        Truth.assertThat((String)actual.getEntityName()).isEqualTo((Object)expected.getEntityName());
                        continue block10;
                    }
                    case PROCESSING_INSTRUCTION: {
                        Truth.assertThat((String)actual.getPITarget()).isEqualTo((Object)expected.getPITarget());
                        Truth.assertThat((String)actual.getPIData()).isEqualTo((Object)expected.getPIData());
                        continue block10;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (TraverserException ex) {
            throw new RuntimeException(ex);
        }
    }
}

