/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testing.multiton;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.testing.multiton.AdapterType;

public final class Adapters {
    private final Map<Class<?>, Object> adapters = new HashMap();
    private boolean initialized;

    public <T> void add(Class<T> type, T adapter) {
        this.adapters.put(type, adapter);
    }

    public void add(Object adapter) {
        this.add(adapter, adapter.getClass(), new HashSet());
    }

    private void add(Object adapter, Class<?> asType, Set<Class<?>> seen) {
        if (seen.add(asType)) {
            Class<?> superClass;
            if (asType.getAnnotation(AdapterType.class) != null) {
                this.adapters.put(asType, adapter);
            }
            if ((superClass = asType.getSuperclass()) != null) {
                this.add(adapter, superClass, seen);
            }
            for (Class<?> iface : asType.getInterfaces()) {
                this.add(adapter, iface, seen);
            }
        }
    }

    <T> T get(Class<T> type) {
        return type.cast(this.adapters.get(type));
    }

    boolean initialized() {
        boolean result = this.initialized;
        this.initialized = true;
        return result;
    }
}

