/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMEntityReference;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.truth.xml.Event;
import org.apache.axiom.truth.xml.Traverser;
import org.apache.axiom.truth.xml.TraverserException;

final class AxiomTraverser
implements Traverser {
    private final OMContainer root;
    private final boolean expandEntityReferences;
    private OMNode node;
    private boolean visited;

    AxiomTraverser(OMContainer root, boolean expandEntityReferences) {
        this.root = root;
        this.expandEntityReferences = expandEntityReferences;
    }

    public Event next() throws TraverserException {
        if (this.node == null) {
            this.node = this.root instanceof OMDocument ? ((OMDocument)this.root).getFirstOMChild() : (OMElement)this.root;
        } else if (!this.visited && this.node instanceof OMElement) {
            OMNode firstChild = ((OMElement)this.node).getFirstOMChild();
            if (firstChild != null) {
                this.node = firstChild;
            } else {
                this.visited = true;
            }
        } else {
            OMNode nextSibling = this.node.getNextOMSibling();
            if (this.node == this.root) {
                return null;
            }
            if (nextSibling != null) {
                this.node = nextSibling;
                this.visited = false;
            } else {
                OMContainer parent = this.node.getParent();
                if (parent instanceof OMDocument) {
                    return null;
                }
                this.node = (OMElement)parent;
                this.visited = true;
            }
        }
        switch (this.node.getType()) {
            case 11: {
                return Event.DOCUMENT_TYPE;
            }
            case 1: {
                return this.visited ? Event.END_ELEMENT : Event.START_ELEMENT;
            }
            case 4: {
                return Event.TEXT;
            }
            case 6: {
                return Event.WHITESPACE;
            }
            case 9: {
                if (this.expandEntityReferences) {
                    throw new UnsupportedOperationException();
                }
                return Event.ENTITY_REFERENCE;
            }
            case 5: {
                return Event.COMMENT;
            }
            case 12: {
                return Event.CDATA_SECTION;
            }
            case 3: {
                return Event.PROCESSING_INSTRUCTION;
            }
        }
        throw new IllegalStateException();
    }

    public String getRootName() {
        return ((OMDocType)this.node).getRootName();
    }

    public String getPublicId() {
        return ((OMDocType)this.node).getPublicId();
    }

    public String getSystemId() {
        return ((OMDocType)this.node).getSystemId();
    }

    public QName getQName() {
        return ((OMElement)this.node).getQName();
    }

    public Map<QName, String> getAttributes() {
        HashMap<QName, String> attributes = null;
        Iterator it = ((OMElement)this.node).getAllAttributes();
        while (it.hasNext()) {
            OMAttribute attr = (OMAttribute)it.next();
            if (attributes == null) {
                attributes = new HashMap<QName, String>();
            }
            attributes.put(attr.getQName(), attr.getAttributeValue());
        }
        return attributes;
    }

    public Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = null;
        Iterator it = ((OMElement)this.node).getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            if (namespaces == null) {
                namespaces = new HashMap<String, String>();
            }
            namespaces.put(ns.getPrefix(), ns.getNamespaceURI());
        }
        return namespaces;
    }

    public String getText() {
        switch (this.node.getType()) {
            case 4: 
            case 6: 
            case 12: {
                return ((OMText)this.node).getText();
            }
            case 5: {
                return ((OMComment)this.node).getValue();
            }
        }
        throw new IllegalStateException();
    }

    public String getEntityName() {
        return ((OMEntityReference)this.node).getName();
    }

    public String getPITarget() {
        return ((OMProcessingInstruction)this.node).getTarget();
    }

    public String getPIData() {
        return ((OMProcessingInstruction)this.node).getValue();
    }
}

