/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.jaxen.BaseXPath;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DOMXPath;
import org.jaxen.function.StringFunction;
import org.jaxen.test.ExprComparator;

public abstract class XPathTestBase
extends TestCase {
    protected static String VAR_URI = "http://jaxen.org/test-harness/var";
    protected static String TESTS_XML = "xml/test/tests.xml";
    protected static boolean verbose = false;
    protected static boolean debug = false;
    private ContextSupport contextSupport;

    protected XPathTestBase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.contextSupport = null;
        System.setProperty("org.saxpath.driver", "");
        this.log("-----------------------------");
    }

    public void log(String text) {
        this.log(verbose, text);
    }

    private void log(boolean actualVerbose, String text) {
        if (actualVerbose) {
            System.out.println(text);
        }
    }

    private void assertCountXPath(int expectedSize, Object context, String xpathStr) throws JaxenException {
        this.assertCountXPath2(expectedSize, context, xpathStr);
    }

    private Object assertCountXPath2(int expectedSize, Object context, String xpathStr) throws JaxenException {
        this.log(debug, "  Select :: " + xpathStr);
        DOMXPath xpath = new DOMXPath(xpathStr);
        List results = xpath.selectNodes((Object)this.getContext(context));
        this.log(debug, "    Expected Size :: " + expectedSize);
        this.log(debug, "    Result Size   :: " + results.size());
        if (expectedSize != results.size()) {
            this.log(debug, "      ## FAILED");
            this.log(debug, "      ## xpath: " + xpath + " = " + xpath.debug());
            Iterator resultIter = results.iterator();
            while (resultIter.hasNext()) {
                this.log(debug, "      --> " + resultIter.next());
            }
        }
        XPathTestBase.assertEquals((String)xpathStr, (int)expectedSize, (int)results.size());
        this.assertExprGetTextIdempotent((BaseXPath)xpath);
        if (expectedSize > 0) {
            return results.get(0);
        }
        return null;
    }

    private void assertInvalidXPath(Object context, String xpathStr) {
        try {
            this.log(debug, "  Select :: " + xpathStr);
            DOMXPath xpath = new DOMXPath(xpathStr);
            List results = xpath.selectNodes((Object)this.getContext(context));
            this.log(debug, "    Result Size   :: " + results.size());
            XPathTestBase.fail((String)"An exception was expected.");
        }
        catch (JaxenException e) {
            this.log(debug, "    Caught expected exception " + e.getMessage());
        }
    }

    private void assertValueOfXPath(String expected, Object context, String xpathStr) throws JaxenException {
        DOMXPath xpath = new DOMXPath(xpathStr);
        Object node = xpath.evaluate((Object)this.getContext(context));
        String result = StringFunction.evaluate((Object)node, (Navigator)this.getNavigator());
        this.log(debug, "  Select :: " + xpathStr);
        this.log(debug, "    Expected :: " + expected);
        this.log(debug, "    Result   :: " + result);
        if (!expected.equals(result)) {
            this.log(debug, "      ## FAILED");
            this.log(debug, "      ## xpath: " + xpath + " = " + xpath.debug());
        }
        XPathTestBase.assertEquals((String)xpathStr, (String)expected, (String)result);
        this.assertExprGetTextIdempotent((BaseXPath)xpath);
    }

    private void assertExprGetTextIdempotent(BaseXPath xpath) throws JaxenException {
        XPathTestBase.assertEquals((int)0, (int)ExprComparator.EXPR_COMPARATOR.compare(xpath.getRootExpr(), new BaseXPath(xpath.getRootExpr().getText(), null).getRootExpr()));
    }

    private Context getContext(Object contextNode) {
        Context context = new Context(this.getContextSupport());
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(contextNode);
        context.setNodeSet(list);
        return context;
    }

    private ContextSupport getContextSupport() {
        if (this.contextSupport == null) {
            this.contextSupport = new ContextSupport((NamespaceContext)new SimpleNamespaceContext(), XPathFunctionContext.getInstance(), (VariableContext)new SimpleVariableContext(), this.getNavigator());
        }
        return this.contextSupport;
    }

    protected abstract Navigator getNavigator();

    protected abstract Object getDocument(String var1) throws Exception;

    public void testGetNodeType() throws FunctionCallException, UnsupportedAxisException {
        Navigator nav = this.getNavigator();
        Object document = nav.getDocument("xml/testNamespaces.xml");
        int count = 0;
        Iterator descendantOrSelfAxisIterator = nav.getDescendantOrSelfAxisIterator(document);
        while (descendantOrSelfAxisIterator.hasNext()) {
            Object node = descendantOrSelfAxisIterator.next();
            Iterator namespaceAxisIterator = nav.getNamespaceAxisIterator(node);
            while (namespaceAxisIterator.hasNext()) {
                ++count;
                XPathTestBase.assertEquals((String)"Node type mismatch", (short)13, (short)nav.getNodeType(namespaceAxisIterator.next()));
            }
        }
        XPathTestBase.assertEquals((int)25, (int)count);
    }

    public void testJaxen24() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/jaxen24.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/body/div", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "preceding::*[1]");
            this.assertValueOfXPath("span", context, "local-name(preceding::*[1])");
        }
    }

    public void testJaxen58() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/jaxen24.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(0, context, "//preceding::x");
            this.assertCountXPath(0, context, "//following::x");
            this.assertCountXPath(0, context, "/descendant::*/preceding::x");
            this.assertCountXPath(0, context, "/descendant::node()/preceding::x");
        }
    }

    public void testJaxen3() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("abd", context, "string()");
        }
    }

    public void testStringFunction1() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/root", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("abd", context, "string()");
        }
    }

    public void testStringFunction2() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/root/a", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("a", context, "string()");
        }
    }

    public void testStringFunction3() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/root/c", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("d", context, "string()");
        }
    }

    public void testJaxen3dupe() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/jaxen3.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/Configuration/hostname/attrlist/hostname[. = 'CE-A'] ");
        }
    }

    public void testForParserErrors() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/numbers.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertInvalidXPath(context, "/numbers numbers");
            this.assertInvalidXPath(context, "/a/b[c > d]efg");
            this.assertInvalidXPath(context, "/inv/child::");
            this.assertInvalidXPath(context, "/invoice/@test[abcd");
            this.assertInvalidXPath(context, "/invoice/@test[abcd > x");
            this.assertInvalidXPath(context, "string-length('a");
            this.assertInvalidXPath(context, "/descendant::()");
            this.assertInvalidXPath(context, "(1 + 1");
            this.assertInvalidXPath(context, "!false()");
        }
    }

    public void testUnderscoresInNames() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/underscore.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/root/@a");
            this.assertCountXPath(1, context, "/root/@_a");
            this.assertCountXPath(1, context, "/root/b");
            this.assertCountXPath(1, context, "/root/_b");
            this.assertValueOfXPath("1", context, "/root/@a");
            this.assertValueOfXPath("2", context, "/root/@_a");
            this.assertValueOfXPath("1", context, "/root/b");
            this.assertValueOfXPath("2", context, "/root/_b");
        }
    }

    public void testNodesetEqualsString() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("true", context, "/web-app/servlet/servlet-name = 'file'");
            this.assertValueOfXPath("true", context, "/web-app/servlet/servlet-name = 'snoop'");
        }
    }

    public void testNodesetEqualsNumber() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/numbers.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("true", context, "/numbers/set/nr = '-3'");
            this.assertValueOfXPath("true", context, "/numbers/set/nr = -3");
            this.assertValueOfXPath("true", context, "/numbers/set/nr = 24");
            this.assertValueOfXPath("true", context, "/numbers/set/nr/@value = '9999'");
            this.assertValueOfXPath("true", context, "/numbers/set/nr/@value = 9999.0");
            this.assertValueOfXPath("true", context, "/numbers/set/nr/@value = 66");
        }
    }

    public void testIntegerArithmetic() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/numbers.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("true", context, "(8 * 2 + 1) = 17");
            this.assertValueOfXPath("true", context, "(1 + 8 * 2) = 17");
            this.assertValueOfXPath("true", context, "(7 - 3 + 1) = 5");
            this.assertValueOfXPath("true", context, "(8 - 4 + 5 - 6) = 3");
            this.assertValueOfXPath("0", context, "3 - 2 - 1");
            this.assertValueOfXPath("1", context, "8 div 4 div 2");
            this.assertValueOfXPath("3", context, "3 mod 7 mod 5");
            this.assertValueOfXPath("false", context, "1 = 2 = 2");
            this.assertValueOfXPath("false", context, "2 != 3 != 1");
            this.assertValueOfXPath("false", context, "3 > 2 > 1");
            this.assertValueOfXPath("false", context, "3 >= 2 >= 2");
            this.assertValueOfXPath("true", context, "1 < 2 < 3");
            this.assertValueOfXPath("true", context, "2 <= 2 <= 3");
        }
    }

    public void testFloatingPointArithmetic() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/numbers.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("true", context, "(8.5 * 2.0 + 1) = 18");
            this.assertValueOfXPath("true", context, "(1.00 + 8.5 * 2) = 18.0");
            this.assertValueOfXPath("true", context, "(7.1 - 7.1 + 1.5) = 1.5");
            this.assertValueOfXPath("true", context, "(8.000 - 4.0 + 5 - 6.00) = 3");
            this.assertValueOfXPath("0", context, "3.5 - 2.5 - 1.0");
            this.assertValueOfXPath("1", context, "8.0 div 4.0 div 2.0");
            this.assertValueOfXPath("3", context, "3.0 mod 7.0 mod 5.0");
            this.assertValueOfXPath("false", context, "1.5 = 2.3 = 2.3");
            this.assertValueOfXPath("false", context, "2.1 != 3.2 != 1.9");
            this.assertValueOfXPath("false", context, "3.8 > 2.7 > 1.6");
            this.assertValueOfXPath("false", context, "3.4 >= 2.5 >= 2.5");
            this.assertValueOfXPath("true", context, "1.4 < 2.3 < 3.2");
            this.assertValueOfXPath("true", context, "2.5 <= 2.5 <= 3.5");
        }
    }

    public void testPrecedingSiblingAxis() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/pi2.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/a/c", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "//processing-instruction()");
            this.assertCountXPath(1, context, "preceding-sibling::*");
            this.assertCountXPath(5, context, "preceding-sibling::node()");
            this.assertCountXPath(1, context, "preceding-sibling::*[1]");
            this.assertCountXPath(1, context, "preceding-sibling::processing-instruction()");
            this.assertValueOfXPath("order-by=\"x\"", context, "preceding-sibling::processing-instruction()");
            this.assertValueOfXPath("foo", context, "preceding-sibling::*[1]");
            this.assertValueOfXPath("order-by=\"x\"", context, "preceding-sibling::node()[2]");
        }
    }

    public void testVariableLookup() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/id.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        SimpleVariableContext varContext = new SimpleVariableContext();
        varContext.setVariableValue(null, "foobar", (Object)"foobar");
        varContext.setVariableValue(null, "foo", (Object)"foo");
        this.getContextSupport().setVariableContext((VariableContext)varContext);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("foobar", context, "$foobar");
            this.assertCountXPath(1, context, "/foo[@id=$foobar]");
            this.assertCountXPath(0, context, "/foo[@id='$foobar']");
            this.assertCountXPath(1, context, "/foo[concat($foo, 'bar')=@id]");
            this.assertCountXPath(0, context, "CD_Library/artist[@name=$artist]");
        }
    }

    public void testAttributeParent() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/id.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/foo/@id/parent::foo");
        }
    }

    public void testAttributeAsContext() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/id.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/foo/@id", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "parent::foo");
        }
    }

    public void testid53992() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/pi.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(3, context, "//processing-instruction()");
            this.assertCountXPath(2, context, "//processing-instruction('cheese')");
            Object result = this.assertCountXPath2(1, context, "//processing-instruction('toast')");
            this.assertValueOfXPath("is tasty", result, "string()");
        }
    }

    public void testid54032() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/evaluate.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(3, context, "evaluate('//jumps/*')");
            this.assertCountXPath(1, context, "evaluate('//jumps/object/dog')");
            this.assertCountXPath(0, context, "evaluate('//jumps/object')/evaluate");
            this.assertCountXPath(1, context, "evaluate('//jumps/object')/dog");
            this.assertCountXPath(1, context, "evaluate('//jumps/*')/dog");
            this.assertCountXPath(1, context, "//metatest[ evaluate(@select) = . ]");
        }
    }

    public void testid54082() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/numbers.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/numbers/set[1]", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "*[-3 = .]");
            this.assertValueOfXPath("true", context, "54 < *");
            this.assertValueOfXPath("true", context, "55 <= *");
            this.assertValueOfXPath("false", context, "69 < *");
            this.assertValueOfXPath("true", context, "-2 > *");
            this.assertValueOfXPath("true", context, "-3 >= *");
            this.assertValueOfXPath("false", context, "-4 >= *");
        }
    }

    public void testid54145() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/axis.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/root", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(0, context, "preceding-sibling::*");
        }
    }

    public void testid54156() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/axis.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/root/a/a.3", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(2, context, "preceding::*");
        }
    }

    public void testid54168() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/axis.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/root/a/a.3", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(2, context, "preceding-sibling::*");
        }
    }

    public void testid54180() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/axis.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("a.2", context, "name(/root/a/a.3/preceding-sibling::*[1])");
            this.assertValueOfXPath("a.1", context, "name(/root/a/a.3/preceding-sibling::*[2])");
        }
    }

    public void testid54197() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/axis.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("a.4", context, "name(/root/a/a.3/following-sibling::*[1])");
            this.assertValueOfXPath("a.5", context, "name(/root/a/a.3/following-sibling::*[2])");
        }
    }

    public void testid54219() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("snoop", context, "/web-app/servlet[1]/servlet-name");
            this.assertValueOfXPath("snoop", context, "/web-app/servlet[1]/servlet-name/text()");
            this.assertValueOfXPath("file", context, "/web-app/servlet[2]/servlet-name");
            this.assertValueOfXPath("file", context, "/web-app/servlet[2]/servlet-name/text()");
        }
    }

    public void testid54249() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/web-app/servlet[1]", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("snoop", context, "servlet-name");
            this.assertValueOfXPath("snoop", context, "servlet-name/text()");
        }
    }

    public void testid54266() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/web-app/servlet[2]/servlet-name", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(3, context, "preceding::*");
        }
    }

    public void testid54278() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/web-app/servlet[2]/servlet-name", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(13, context, "following::*");
        }
    }

    public void testid54298() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            Object result = this.assertCountXPath2(1, context, "*");
            this.assertValueOfXPath("web-app", result, "name()");
            result = this.assertCountXPath2(1, context, "./*");
            this.assertValueOfXPath("web-app", result, "name()");
            result = this.assertCountXPath2(1, context, "child::*");
            this.assertValueOfXPath("web-app", result, "name()");
            result = this.assertCountXPath2(1, context, "/*");
            this.assertValueOfXPath("web-app", result, "name()");
            result = this.assertCountXPath2(1, context, "/child::node()");
            this.assertValueOfXPath("web-app", result, "name(.)");
            result = this.assertCountXPath2(1, context, "child::node()");
            this.assertValueOfXPath("web-app", result, "name(.)");
            this.assertValueOfXPath("", context, "name()");
            this.assertValueOfXPath("", context, "name(.)");
            this.assertValueOfXPath("", context, "name(parent::*)");
            this.assertValueOfXPath("", context, "name(/)");
            this.assertValueOfXPath("", context, "name(/.)");
            this.assertValueOfXPath("", context, "name(/self::node())");
            this.assertValueOfXPath("web-app", context, "name(node())");
            this.assertValueOfXPath("web-app", context, "name(/node())");
            this.assertValueOfXPath("web-app", context, "name(/*)");
            this.assertValueOfXPath("web-app", context, "name(/child::*)");
            this.assertValueOfXPath("web-app", context, "name(/child::node())");
            this.assertValueOfXPath("web-app", context, "name(/child::node())");
            this.assertValueOfXPath("web-app", context, "name(child::node())");
            this.assertValueOfXPath("web-app", context, "name(./*)");
            this.assertValueOfXPath("web-app", context, "name(*)");
        }
    }

    public void testid54467() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/*", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("", context, "name(..)");
            this.assertValueOfXPath("", context, "name(parent::node())");
            this.assertValueOfXPath("", context, "name(parent::*)");
            this.assertValueOfXPath("web-app", context, "name()");
            this.assertValueOfXPath("web-app", context, "name(.)");
            this.assertValueOfXPath("web-app", context, "name(../*)");
            this.assertValueOfXPath("web-app", context, "name(../child::node())");
        }
    }

    public void testid54522() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/nitf.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/nitf/head/docdata", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "doc-id[@regsrc='FAKE' and @id-string='YYY']");
        }
    }

    public void testid54534() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/nitf.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/nitf/head", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "meta[@name='fake-cycle']");
            this.assertCountXPath(1, context, "meta[@content='FAKE']");
            this.assertCountXPath(8, context, "meta[@name and @content]");
            this.assertCountXPath(1, context, "meta[@name='fake-cycle' and @content='FAKE']");
            this.assertCountXPath(7, context, "meta[@name != 'fake-cycle']");
        }
    }

    public void testid54570() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/nitf.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/nitf/head/meta[@name='fake-cycle']");
            this.assertCountXPath(1, context, "/nitf/head/meta[@content='FAKE']");
            this.assertCountXPath(8, context, "/nitf/head/meta[@name and @content]");
            this.assertCountXPath(1, context, "/nitf/head/meta[@name='fake-cycle' and @content='FAKE']");
            this.assertCountXPath(7, context, "/nitf/head/meta[@name != 'fake-cycle']");
        }
    }

    public void testid54614() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/moreover.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/child::node()");
            this.assertCountXPath(1, context, "/*");
            this.assertCountXPath(20, context, "/*/article");
            this.assertCountXPath(221, context, "//*");
            this.assertCountXPath(20, context, "//*[local-name()='article']");
            this.assertCountXPath(20, context, "//article");
            this.assertCountXPath(20, context, "/*/*[@code]");
            this.assertCountXPath(1, context, "/moreovernews/article[@code='13563275']");
            DOMXPath xpath = new DOMXPath("/moreovernews/article[@code='13563275']");
            List results = xpath.selectNodes((Object)this.getContext(context));
            Object result = results.get(0);
            this.assertValueOfXPath("http://c.moreover.com/click/here.pl?x13563273", result, "url");
            xpath = new DOMXPath("/*/article[@code='13563275']");
            results = xpath.selectNodes((Object)this.getContext(context));
            result = results.get(0);
            this.assertValueOfXPath("http://c.moreover.com/click/here.pl?x13563273", result, "url");
            xpath = new DOMXPath("//article[@code='13563275']");
            results = xpath.selectNodes((Object)this.getContext(context));
            result = results.get(0);
            this.assertValueOfXPath("http://c.moreover.com/click/here.pl?x13563273", result, "url");
            xpath = new DOMXPath("//*[@code='13563275']");
            results = xpath.selectNodes((Object)this.getContext(context));
            result = results.get(0);
            this.assertValueOfXPath("http://c.moreover.com/click/here.pl?x13563273", result, "url");
            xpath = new DOMXPath("/child::node()/child::node()[@code='13563275']");
            results = xpath.selectNodes((Object)this.getContext(context));
            result = results.get(0);
            this.assertValueOfXPath("http://c.moreover.com/click/here.pl?x13563273", result, "url");
            xpath = new DOMXPath("/*/*[@code='13563275']");
            results = xpath.selectNodes((Object)this.getContext(context));
            result = results.get(0);
            this.assertValueOfXPath("http://c.moreover.com/click/here.pl?x13563273", result, "url");
        }
    }

    public void testNodeTypes() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/contents.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(3, context, "processing-instruction()");
            this.assertCountXPath(3, context, "/processing-instruction()");
            this.assertCountXPath(1, context, "/comment()");
            this.assertCountXPath(1, context, "comment()");
            this.assertCountXPath(2, context, "/child::node()/comment()");
            this.assertCountXPath(2, context, "/*/comment()");
            this.assertCountXPath(3, context, "//comment()");
        }
    }

    public void testPositioning() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/fibo.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(9, context, "/*/fibonacci[position() < 10]");
            this.assertValueOfXPath("196417", context, "sum(//fibonacci)");
            this.assertValueOfXPath("325", context, "sum(//fibonacci/@index)");
            this.assertValueOfXPath("1", context, "/*/fibonacci[2]");
            this.assertValueOfXPath("75025", context, "/*/fibonacci[ count(/*/fibonacci) ]");
            this.assertValueOfXPath("46368", context, "/*/fibonacci[ count(/*/fibonacci) - 1 ]");
        }
    }

    public void testid54853() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(19, context, "descendant-or-self::*");
            this.assertCountXPath(19, context, "descendant::*");
            this.assertCountXPath(19, context, "/descendant::*");
            this.assertCountXPath(19, context, "/descendant-or-self::*");
            this.assertCountXPath(2, context, "/descendant::servlet");
            this.assertCountXPath(2, context, "/descendant-or-self::servlet");
            this.assertCountXPath(2, context, "descendant-or-self::servlet");
            this.assertCountXPath(2, context, "descendant::servlet");
            this.assertCountXPath(2, context, "/*/servlet");
            this.assertValueOfXPath("2", context, "count(/*/servlet)");
            this.assertCountXPath(2, context, "//servlet");
            this.assertValueOfXPath("2", context, "count(//servlet)");
        }
    }

    public void testid54932() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/web-app", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(2, context, "/descendant::servlet");
            this.assertCountXPath(2, context, "/descendant-or-self::servlet");
            this.assertCountXPath(2, context, "descendant-or-self::servlet");
            this.assertCountXPath(2, context, "descendant::servlet");
        }
    }

    public void testCountFunction() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/much_ado.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(5, context, "/descendant::ACT");
            this.assertCountXPath(5, context, "descendant::ACT");
            this.assertValueOfXPath("Much Ado about Nothing", context, "/PLAY/TITLE");
            this.assertValueOfXPath("4", context, "2+2");
            this.assertValueOfXPath("21", context, "5 * 4 + 1");
            this.assertValueOfXPath("5", context, "count(descendant::ACT)");
            this.assertValueOfXPath("35", context, "10 + count(descendant::ACT) * 5");
            this.assertValueOfXPath("75", context, "(10 + count(descendant::ACT)) * 5");
        }
    }

    public void testCountFunctionMore() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/much_ado.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/PLAY/ACT[2]/SCENE[1]", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(5, context, "/descendant::ACT");
            this.assertCountXPath(5, context, "../../descendant::ACT");
            this.assertCountXPath(141, context, "/PLAY/ACT[2]/SCENE[1]/descendant::SPEAKER");
            this.assertCountXPath(141, context, "descendant::SPEAKER");
            this.assertValueOfXPath("646", context, "count(descendant::*)+1");
            this.assertValueOfXPath("142", context, "count(descendant::SPEAKER)+1");
            this.assertValueOfXPath("2", context, "count(ancestor::*)");
            this.assertValueOfXPath("1", context, "count(ancestor::PLAY)");
            this.assertValueOfXPath("3", context, "count(ancestor-or-self::*)");
            this.assertValueOfXPath("1", context, "count(ancestor-or-self::PLAY)");
            this.assertValueOfXPath("6", context, "5+count(ancestor::*)-1");
        }
    }

    public void testCorrectPredicateApplication() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/much_ado.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("5", context, "count(/PLAY/ACT/SCENE[1])");
        }
    }

    public void testAxisNodeOrdering() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "//servlet-mapping/preceding::*[1][name()='description']");
            this.assertCountXPath(1, context, "/web-app/servlet//description/following::*[1][name()='servlet-mapping']");
            this.assertCountXPath(1, context, "/web-app/servlet//description/following::*[2][name()='servlet-name']");
        }
    }

    public void testDocumentFunction1() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/text.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            Object result = this.assertCountXPath2(1, context, "document('xml/web.xml')");
            this.assertValueOfXPath("snoop", result, "/web-app/servlet[1]/servlet-name");
            this.assertValueOfXPath("snoop", result, "/web-app/servlet[1]/servlet-name/text()");
            this.assertValueOfXPath("snoop", context, "document('xml/web.xml')/web-app/servlet[1]/servlet-name");
        }
    }

    public void testDocumentFunctionContextExample() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/text.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/foo/bar/cheese[1]", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("3foo3", context, "concat(./@id,'foo',@id)");
            this.assertValueOfXPath("3snoop3", context, "concat(./@id,document('xml/web.xml')/web-app/servlet[1]/servlet-name,./@id)");
        }
    }

    public void testDocumentFunctionActual() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/message.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("Pruefgebiete", context, "/message/body/data/items/item[name/text()='parentinfo']/value");
            this.assertValueOfXPath("Pruefgebiete", context, "document('xml/message.xml')/message/body/data/items/item[name/text()='parentinfo']/value");
        }
    }

    public void testAbsoluteLocationPaths() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/root/a", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("ab", context, "concat( ., /root/b )");
            this.assertValueOfXPath("ba", context, "concat( ../b, . )");
            this.assertValueOfXPath("ba", context, "concat( /root/b, . )");
            this.assertValueOfXPath("db", context, "concat( /root/c/d, ../b )");
        }
    }

    public void testTranslateFunction() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("", context, "translate( '', '', '' )");
            this.assertValueOfXPath("abcd", context, "translate( 'abcd', '', '' )");
            this.assertValueOfXPath("abcd", context, "translate( 'abcd', 'abcd', 'abcd' )");
            this.assertValueOfXPath("abcd", context, "translate( 'abcd', 'dcba', 'dcba' )");
            this.assertValueOfXPath("dcba", context, "translate( 'abcd', 'abcd', 'dcba' )");
            this.assertValueOfXPath("ab", context, "translate( 'abcd', 'abcd', 'ab' )");
            this.assertValueOfXPath("cd", context, "translate( 'abcd', 'cdab', 'cd' )");
            this.assertValueOfXPath("xy", context, "translate( 'abcd', 'acbd', 'xy' )");
            this.assertValueOfXPath("abcd", context, "translate( 'abcd', 'abcdb', 'abcdb' )");
            this.assertValueOfXPath("abcd", context, "translate( 'abcd', 'abcd', 'abcdb' )");
        }
    }

    public void testSubstringFunction() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("234", context, "substring('12345', 1.5, 2.6)");
            this.assertValueOfXPath("12", context, "substring('12345', 0, 3)");
            this.assertValueOfXPath("", context, "substring('12345', 0 div 0, 3)");
            this.assertValueOfXPath("", context, "substring('12345', 1, 0 div 0)");
            this.assertValueOfXPath("12345", context, "substring('12345', -42, 1 div 0)");
            this.assertValueOfXPath("", context, "substring('12345', -1 div 0, 1 div 0)");
            this.assertValueOfXPath("345", context, "substring('12345', 3)");
            this.assertValueOfXPath("12345", context, "substring('12345',1,15)");
        }
    }

    public void testNormalizeSpaceFunction() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/simple.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("abc", context, "normalize-space('    abc    ')");
            this.assertValueOfXPath("a b c", context, "normalize-space(' a  b  c  ')");
            this.assertValueOfXPath("a b c", context, "normalize-space(' a \n b \n  c')");
            this.assertValueOfXPath("", context, "normalize-space(' ')");
            this.assertValueOfXPath("", context, "normalize-space('')");
        }
    }

    public void testStringExtensionFunctions() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/web.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/web-app/servlet[1]", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("SNOOPSERVLET", context, "upper-case( servlet-class )");
            this.assertValueOfXPath("snoopservlet", context, "lower-case( servlet-class )");
            this.assertValueOfXPath("SNOOPSERVLET", context, "upper-case( servlet-class, 'fr' )");
            this.assertValueOfXPath("SNOOPSERVLET", context, "upper-case( servlet-class, 'fr-CA' )");
            this.assertValueOfXPath("SNOOPSERVLET", context, "upper-case( servlet-class, 'es-ES-Traditional_WIN' )");
            this.assertValueOfXPath("true", context, "ends-with( servlet-class, 'Servlet' )");
            this.assertValueOfXPath("false", context, "ends-with( servlet-class, 'S' )");
        }
    }

    public void testLangFunction() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/lang.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(0, context, "/e1/e2[lang('hr')]");
            this.assertCountXPath(1, context, "/e1/e2/e3[lang('en')]");
            this.assertCountXPath(1, context, "/e1/e2/e3[lang('en-US')]");
            this.assertCountXPath(0, context, "/e1/e2/e3[lang('en-GB')]");
            this.assertCountXPath(2, context, "/e1/e2/e3[lang('hu')]");
            this.assertCountXPath(0, context, "/e1/e2/e3[lang('hu-HU')]");
            this.assertCountXPath(1, context, "/e1/e2/e3[lang('es')]");
            this.assertCountXPath(0, context, "/e1/e2/e3[lang('es-BR')]");
        }
    }

    public void testNamespacesAgain() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/namespaces.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
        nsContext.addNamespace("alias", "http://fooNamespace/");
        nsContext.addNamespace("bar", "http://barNamespace/");
        nsContext.addNamespace("voo", "http://fooNamespace/");
        nsContext.addNamespace("foo", "http://fooNamespace/");
        this.getContextSupport().setNamespaceContext((NamespaceContext)nsContext);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/*");
            this.assertCountXPath(1, context, "/foo:a");
            this.assertCountXPath(1, context, "/foo:a/b");
            this.assertCountXPath(1, context, "/voo:a/b/c");
            this.assertCountXPath(1, context, "/voo:a/bar:f");
            this.assertCountXPath(1, context, "/*[namespace-uri()='http://fooNamespace/' and local-name()='a']");
            this.assertCountXPath(1, context, "/*[local-name()='a' and namespace-uri()='http://fooNamespace/']/*[local-name()='x' and namespace-uri()='http://fooNamespace/']");
            this.assertCountXPath(1, context, "/*[local-name()='a' and namespace-uri()='http://fooNamespace/']/*[local-name()='x' and namespace-uri()='http://fooNamespace/']/*[local-name()='y' and namespace-uri()='http://fooNamespace/']");
        }
    }

    public void testPrefixDoesntMatter() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/namespaces.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
        nsContext.addNamespace("foo", "http://somethingElse/");
        this.getContextSupport().setNamespaceContext((NamespaceContext)nsContext);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(0, context, "/foo:a/b/c");
        }
    }

    public void testCDATASectionsAreIncludedInTextNodes() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/cdata.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextPath = new BaseXPath("/p/text()", nav);
        this.log("Initial Context :: " + contextPath);
        List list = contextPath.selectNodes(document);
        StringBuffer buffer = new StringBuffer(10);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            buffer.append(StringFunction.evaluate(iterator.next(), (Navigator)nav));
        }
        XPathTestBase.assertEquals((String)"awhateverb", (String)buffer.toString());
    }

    public void testNamespaces() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/namespaces.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
        nsContext.addNamespace("alias", "http://fooNamespace/");
        nsContext.addNamespace("bar", "http://barNamespace/");
        nsContext.addNamespace("foo", "http://fooNamespace/");
        this.getContextSupport().setNamespaceContext((NamespaceContext)nsContext);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertValueOfXPath("Hello", context, "/foo:a/b/c");
            this.assertValueOfXPath("Hey", context, "/foo:a/foo:d/foo:e");
            this.assertValueOfXPath("Hey3", context, "/foo:a/alias:x/alias:y");
            this.assertValueOfXPath("Hey3", context, "/foo:a/foo:x/foo:y");
            this.assertValueOfXPath("Hey3", context, "/*[local-name()='a' and namespace-uri()='http://fooNamespace/']/*[local-name()='x' and namespace-uri()='http://fooNamespace/']/*[local-name()='y' and namespace-uri()='http://fooNamespace/']");
        }
    }

    public void testNoNamespace() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/defaultNamespace.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(0, context, "/a/b/c");
        }
    }

    public void testNamespaceResolution() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/defaultNamespace.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
        nsContext.addNamespace("dummy", "http://dummyNamespace/");
        this.getContextSupport().setNamespaceContext((NamespaceContext)nsContext);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/dummy:a/dummy:b/dummy:c");
        }
    }

    public void testTextNodes() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/text.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(3, context, "/foo/bar/text()");
            this.assertValueOfXPath("baz", context, "normalize-space(/foo/bar/text())");
        }
    }

    public void testNamespaceNodeCounts1() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/testNamespaces.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(0, context, "namespace::*");
            this.assertCountXPath(0, context, "/namespace::*");
            this.assertCountXPath(3, context, "/Template/Application1/namespace::*");
            this.assertCountXPath(3, context, "/Template/Application2/namespace::*");
            this.assertCountXPath(25, context, "//namespace::*");
        }
    }

    public void testNamespaceNodeCounts() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/testNamespaces.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/Template/Application1", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(3, context, "namespace::*");
            this.assertCountXPath(0, context, "/namespace::*");
            this.assertCountXPath(3, context, "/Template/Application1/namespace::*");
            this.assertCountXPath(3, context, "/Template/Application2/namespace::*");
            this.assertCountXPath(25, context, "//namespace::*");
            this.assertCountXPath(8, context, "//namespace::xplt");
            this.assertCountXPath(0, context, "//namespace::somethingelse");
        }
    }

    public void testNamespaceNodesHaveParent() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/testNamespaces.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "/Template/namespace::xml/parent::Template");
        }
    }

    public void testNamespaceNodeAsContext() throws JaxenException {
        Navigator nav = this.getNavigator();
        String url = "xml/testNamespaces.xml";
        this.log("Document [" + url + "]");
        Object document = nav.getDocument(url);
        BaseXPath contextpath = new BaseXPath("/Template/namespace::xml", nav);
        this.log("Initial Context :: " + contextpath);
        List list = contextpath.selectNodes(document);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object context = iter.next();
            this.assertCountXPath(1, context, "parent::Template");
        }
    }
}

