/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom.soap12;

import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.common.SOAPHelper;
import org.apache.axiom.soap.impl.dom.SOAPHeaderBlockImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12HeaderImpl;

public class SOAP12HeaderBlockImpl
extends SOAPHeaderBlockImpl {
    public SOAP12HeaderBlockImpl(ParentNode parentNode, String localName, OMNamespace ns, OMXMLParserWrapper builder, OMFactory factory, boolean generateNSDecl) {
        super(parentNode, localName, ns, builder, factory, generateNSDecl);
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAP12HeaderImpl)) {
            throw new SOAPProcessingException("Expecting SOAP 1.2 implementation of SOAP Body as the parent. But received some other implementation");
        }
    }

    public void setRole(String roleURI) {
        this.setAttribute("role", roleURI, "http://www.w3.org/2003/05/soap-envelope");
    }

    public String getRole() {
        return this.getAttribute("role", "http://www.w3.org/2003/05/soap-envelope");
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.setAttribute("mustUnderstand", mustUnderstand ? "true" : "false", "http://www.w3.org/2003/05/soap-envelope");
    }

    public void setRelay(boolean relay) {
        this.setAttribute("relay", String.valueOf(relay), "http://www.w3.org/2003/05/soap-envelope");
    }

    public boolean getRelay() {
        String val = this.getAttribute("relay", "http://www.w3.org/2003/05/soap-envelope");
        if (val != null) {
            Boolean parsedValue = SOAPHelper.SOAP12.parseBoolean(val);
            if (parsedValue == null) {
                throw new SOAPProcessingException("Invalid relay attribute value");
            }
            return parsedValue;
        }
        return false;
    }

    public SOAPVersion getVersion() {
        return SOAP12Version.getSingleton();
    }

    protected SOAPHelper getSOAPHelper() {
        return SOAPHelper.SOAP12;
    }

    protected OMElement createClone(OMCloneOptions options, ParentNode targetParent, boolean generateNSDecl) {
        SOAP12HeaderBlockImpl clone = new SOAP12HeaderBlockImpl(targetParent, this.getLocalName(), this.getNamespace(), null, this.getOMFactory(), generateNSDecl);
        this.copyData(options, clone);
        return clone;
    }
}

