/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreChildNodeSupport;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.CoreParentNodeSupport;
import org.apache.axiom.core.DeferringParentNodeSupport;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.dom.DOMChildNodeSupport;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMElement;
import org.apache.axiom.dom.DOMElementSupport;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMParentNodeSupport;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.impl.common.AxiomChildNode;
import org.apache.axiom.om.impl.common.AxiomChildNodeSupport;
import org.apache.axiom.om.impl.common.AxiomContainer;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElement;
import org.apache.axiom.om.impl.common.AxiomElementSupport;
import org.apache.axiom.om.impl.common.AxiomInformationItemSupport;
import org.apache.axiom.om.impl.common.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.common.AxiomSerializableSupport;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.AttributeMap;
import org.apache.axiom.om.impl.dom.DOMContainer;
import org.apache.axiom.om.impl.dom.DOMContainerSupport;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.NSDeclIterator;
import org.apache.axiom.om.impl.dom.NamedNode;
import org.apache.axiom.om.impl.dom.NamedNodeSupport;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements DOMElement,
AxiomElement,
NamedNode,
OMConstants,
DOMContainer {
    private static final Log log = LogFactory.getLog(ElementImpl.class);
    private int lineNumber;
    private AttributeMap attributes;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();
    public OMNamespace namespace;
    public String localName;
    public QName qName;
    public OMXMLParserWrapper builder;
    public CoreParentNode owner;
    public CoreChildNode nextSibling;
    public CoreChildNode previousSibling;

    public ElementImpl(ParentNode parentNode, String localName, OMNamespace ns, OMXMLParserWrapper builder, OMFactory factory, boolean generateNSDecl) {
        super(factory);
        DeferringParentNodeSupport.ajc$interFieldInit$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$builder(this);
        CoreChildNodeSupport.ajc$interFieldInit$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$owner(this);
        CoreChildNodeSupport.ajc$interFieldInit$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$nextSibling(this);
        CoreChildNodeSupport.ajc$interFieldInit$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$previousSibling(this);
        AxiomNamedInformationItemSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$namespace(this);
        AxiomNamedInformationItemSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$localName(this);
        AxiomNamedInformationItemSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$qName(this);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(this, localName);
        DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetBuilder(this, builder);
        DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetState(this, builder == null ? 1 : 0);
        if (parentNode != null) {
            if (parentNode instanceof AxiomContainer) {
                AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$addChild((AxiomContainer)((Object)parentNode), (OMNode)this, builder != null);
            } else {
                CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChild(parentNode, this, builder != null);
            }
        }
        this.attributes = new AttributeMap(this);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetNamespace(this, generateNSDecl ? AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$handleNamespace(this, this, ns, false, true) : ns);
    }

    public String getTagName() {
        OMNamespace namespace = AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(this);
        String localName = AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getLocalName(this);
        if (namespace != null) {
            if (namespace.getPrefix() == null || "".equals(namespace.getPrefix())) {
                return localName;
            }
            return String.valueOf(namespace.getPrefix()) + ":" + localName;
        }
        return localName;
    }

    public String getNamespaceURI() {
        OMNamespace namespace = AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(this);
        if (namespace == null) {
            return null;
        }
        String uri = namespace.getNamespaceURI();
        return uri.length() == 0 ? null : uri.intern();
    }

    public void removeAttribute(String name) throws DOMException {
        if (this.attributes != null) {
            this.attributes.removeNamedItem(name);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (this.attributes != null) {
            this.attributes.removeNamedItemNS(namespaceURI, localName);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr.getOwnerElement() != this) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        this.attributes.remove((AttrImpl)oldAttr, true);
        return oldAttr;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        return attr != null ? attr.getValue() : "";
    }

    public Attr getAttributeNode(String name) {
        return this.attributes == null ? null : (AttrImpl)this.attributes.getNamedItem(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return "";
        }
        Attr attributeNodeNS = this.getAttributeNodeNS(namespaceURI, localName);
        return attributeNodeNS == null ? "" : attributeNodeNS.getValue();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)attr;
        this.checkSameOwnerDocument(attr);
        attrImpl.checkInUse();
        if (attr.getNodeName().startsWith("xmlns:")) {
            this.declareNamespace(attr.getNodeValue(), DOMUtil.getLocalName(attr.getName()));
            return attr;
        }
        if (attr.getNodeName().equals("xmlns")) {
            this.declareDefaultNamespace(attr.getValue());
            return attr;
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (!DOMUtil.isQualifiedName(name)) {
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        if (name.startsWith("xmlns:")) {
            this.declareNamespace(value, DOMUtil.getLocalName(name));
        } else if (name.equals("xmlns")) {
            this.declareDefaultNamespace(value);
        } else {
            this.setAttributeNode(new AttrImpl(this.ownerDocument(), name, value, this.getOMFactory()));
        }
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return this.setAttributeNodeNS(attr, true, false);
    }

    private Attr setAttributeNodeNS(Attr attr, boolean useDomSemantics, boolean generateNSDecl) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)attr;
        if (useDomSemantics) {
            this.checkSameOwnerDocument(attr);
        }
        attrImpl.checkInUse();
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        if (generateNSDecl && attr.getNamespaceURI() != null && this.findNamespace(attr.getNamespaceURI(), attr.getPrefix()) == null) {
            this.declareNamespace(new OMNamespaceImpl(attr.getNamespaceURI(), attr.getPrefix()));
        }
        return (Attr)this.attributes.setAttribute(attr, useDomSemantics);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        DOMUtil.validateAttrName(namespaceURI, localName, prefix);
        AttrImpl attr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            NamedNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_dom_NamedNodeSupport$org_apache_axiom_om_impl_dom_NamedNode$setPrefix(attr, prefix);
            attr.setValue(value);
        } else if (namespaceURI != null) {
            attr = new AttrImpl(this.ownerDocument(), localName, value, this.getOMFactory());
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetNamespace(attr, new OMNamespaceImpl(namespaceURI, prefix == null ? "" : prefix));
            this.setAttributeNodeNS(attr);
        } else {
            this.setAttribute(localName, value);
        }
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() > 0;
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        String prefix;
        OMNamespace ns2;
        String uri;
        OMNamespace namespace;
        OMElement owner = attr.getOwner();
        if (owner != null) {
            if (owner == this) {
                return attr;
            }
            attr = new AttrImpl(null, attr.getLocalName(), attr.getNamespace(), attr.getAttributeValue(), attr.getOMFactory());
        }
        if (!((namespace = attr.getNamespace()) == null || (uri = namespace.getNamespaceURI()).length() <= 0 || (ns2 = this.findNamespaceURI(prefix = namespace.getPrefix())) != null && uri.equals(ns2.getNamespaceURI()))) {
            this.declareNamespace(uri, prefix);
        }
        this.setAttributeNodeNS((Attr)attr, false, true);
        return attr;
    }

    public OMAttribute addAttribute(String localName, String value, OMNamespace ns) {
        OMNamespace namespace = null;
        if (ns != null) {
            String namespaceURI = ns.getNamespaceURI();
            String prefix = ns.getPrefix();
            if ((namespaceURI.length() > 0 || prefix != null) && ((namespace = this.findNamespace(namespaceURI, prefix)) == null || prefix == null && namespace.getPrefix().length() == 0)) {
                namespace = new OMNamespaceImpl(namespaceURI, prefix != null ? prefix : OMSerializerUtil.getNextNSPrefix());
            }
        }
        return this.addAttribute(new AttrImpl(null, localName, namespace, value, this.getOMFactory()));
    }

    public OMNamespace addNamespaceDeclaration(String uri, String prefix) {
        OMNamespaceImpl ns = new OMNamespaceImpl(uri, prefix);
        this.addNamespaceDeclaration(ns);
        return ns;
    }

    public void addNamespaceDeclaration(OMNamespace ns) {
        String prefix = ns.getPrefix();
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, ns.getNamespaceURI());
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        if (namespace != null) {
            String prefix = namespace.getPrefix();
            if (prefix == null) {
                prefix = OMSerializerUtil.getNextNSPrefix();
                namespace = new OMNamespaceImpl(namespace.getNamespaceURI(), prefix);
            }
            if (prefix.length() > 0 && namespace.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("Cannot bind a prefix to the empty namespace name");
            }
            if (!namespace.getPrefix().startsWith("xmlns")) {
                this.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, namespace.getNamespaceURI());
            }
        }
        return namespace;
    }

    public void undeclarePrefix(String prefix) {
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, "");
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        if ("".equals(prefix)) {
            log.warn((Object)"Deprecated usage of OMElement#declareNamespace(String,String) with empty prefix");
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        OMNamespaceImpl ns = new OMNamespaceImpl(uri, prefix);
        return this.declareNamespace(ns);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        OMNamespace namespace = AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(this);
        if (namespace == null && uri.length() > 0 || namespace != null && namespace.getPrefix().length() == 0 && !namespace.getNamespaceURI().equals(uri)) {
            throw new OMException("Attempt to add a namespace declaration that conflicts with the namespace information of the element");
        }
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
        return new OMNamespaceImpl(uri, "");
    }

    public OMNamespace getDefaultNamespace() {
        Attr decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (decl != null) {
            String uri = decl.getValue();
            return uri.length() == 0 ? null : new OMNamespaceImpl(uri, "");
        }
        ParentNode parentNode = (ParentNode)CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(this);
        if (parentNode instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)parentNode;
            return element.getDefaultNamespace();
        }
        return null;
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        ParentNode parentNode = (ParentNode)CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(this);
        if (parentNode != null && parentNode instanceof OMElement) {
            namespace = ((ElementImpl)parentNode).findNamespace(uri, prefix);
            if (prefix == null && namespace != null && this.findDeclaredNamespace(null, namespace.getPrefix()) != null) {
                namespace = null;
            }
        }
        if (namespace == null && uri != null && prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.declareNamespace("http://www.w3.org/XML/1998/namespace", "xml");
            namespace = this.findNamespace(uri, prefix);
        }
        return namespace;
    }

    public OMNamespace findNamespaceURI(String prefix) {
        Attr decl;
        if (this.attributes != null && (decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : prefix)) != null) {
            String namespaceURI = decl.getValue();
            if (prefix != null && prefix.length() > 0 && namespaceURI.length() == 0) {
                return null;
            }
            return new OMNamespaceImpl(namespaceURI, prefix);
        }
        ParentNode parentNode = (ParentNode)CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(this);
        if (parentNode instanceof OMElement) {
            return ((OMElement)parentNode).findNamespaceURI(prefix);
        }
        return null;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            Attr decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : prefix);
            return decl == null ? null : new OMNamespaceImpl(decl.getValue(), prefix);
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return new OMNamespaceImpl(uri, prefix);
        }
        if (prefix == null || "".equals(prefix)) {
            int i = 0;
            while (i < this.attributes.getLength()) {
                String declaredUri;
                Attr attr = (Attr)this.attributes.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) && (declaredUri = attr.getValue()).equals(uri)) {
                    return new OMNamespaceImpl(uri, attr.getPrefix() == null ? "" : attr.getLocalName());
                }
                ++i;
            }
        } else {
            String declaredUri;
            Attr decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix);
            if (decl != null && (declaredUri = decl.getValue()).equals(uri)) {
                return new OMNamespaceImpl(uri, prefix);
            }
        }
        return null;
    }

    public OMAttribute getAttribute(QName qname) {
        if (this.attributes == null) {
            return null;
        }
        if (qname.getNamespaceURI().equals("")) {
            return (AttrImpl)this.getAttributeNode(qname.getLocalPart());
        }
        return (AttrImpl)this.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    public void removeAttribute(OMAttribute attr) {
        if (attr.getOwner() != this) {
            throw new OMException("The attribute is not owned by this element");
        }
        this.attributes.remove((AttrImpl)attr, false);
    }

    public void setNamespace(OMNamespace namespace) {
        AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$setNamespace(this, namespace, true);
    }

    public void internalSerialize(Serializer serializer, OMOutputFormat format, boolean cache) throws OutputException {
        serializer.serializeStartpart((OMElement)this);
        serializer.serializeChildren(this, format, cache);
        serializer.writeEndElement();
    }

    public String toStringWithConsume() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serializeAndConsume((AxiomContainer)this, baos);
        return new String(baos.toByteArray());
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serialize((AxiomContainer)this, baos);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can not serialize OM Element " + AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getLocalName(this), e);
        }
        return new String(baos.toByteArray());
    }

    public Iterator getAllDeclaredNamespaces() throws OMException {
        return new NSDeclIterator(this.attributes);
    }

    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        ArrayList<OMAttribute> list = new ArrayList<OMAttribute>();
        int i = 0;
        while (i < this.attributes.getLength()) {
            OMAttribute item = (OMAttribute)this.attributes.getItem(i);
            if (item.getNamespace() == null || item.getNamespace() == null || !"http://www.w3.org/2000/xmlns/".equals(item.getNamespace().getNamespaceURI())) {
                list.add(item);
            }
            ++i;
        }
        return list.iterator();
    }

    public OMElement cloneOMElement() {
        return (OMElement)this.clone(new OMCloneOptions());
    }

    final ParentNode shallowClone(OMCloneOptions options, ParentNode targetParent, boolean namespaceRepairing) {
        ElementImpl clone = options.isPreserveModel() ? (ElementImpl)this.createClone(options, targetParent, namespaceRepairing) : new ElementImpl(targetParent, AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getLocalName(this), AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(this), null, this.getOMFactory(), namespaceRepairing);
        int i = 0;
        int l = this.attributes.getLength();
        while (i < l) {
            AttrImpl attr = (AttrImpl)this.attributes.item(i);
            AttrImpl clonedAttr = (AttrImpl)attr.clone(options, null, true, false);
            clonedAttr.setSpecified(attr.getSpecified());
            clone.setAttributeNodeNS(clonedAttr, false, namespaceRepairing && !"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()));
            ++i;
        }
        return clone;
    }

    protected OMElement createClone(OMCloneOptions options, ParentNode targetParent, boolean generateNSDecl) {
        return new ElementImpl(targetParent, AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getLocalName(this), AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(this), null, this.getOMFactory(), generateNSDecl);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public String getNamespaceURI(String prefix) {
        OMNamespace ns = this.findNamespaceURI(prefix);
        return ns != null ? ns.getNamespaceURI() : null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNode(name);
        if (tempAttr == null) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (tempAttr == null) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        Iterator attrIter = this.getAllAttributes();
        AttrImpl tempAttr = null;
        while (attrIter.hasNext()) {
            AttrImpl attr = (AttrImpl)attrIter.next();
            if (!attr.equals(idAttr)) continue;
            tempAttr = attr;
            break;
        }
        if (tempAttr == null) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        this.updateIsId(isId, tempAttr);
    }

    private void updateIsId(boolean isId, AttrImpl tempAttr) {
        tempAttr.isId = isId;
        if (isId) {
            this.ownerDocument().addIdAttr(tempAttr);
        } else {
            this.ownerDocument().removeIdAttr(tempAttr);
        }
    }

    public void buildWithAttachments() {
        if (DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$getState(this) == 0) {
            this.build();
        }
        Iterator iterator = AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_OMContainer$getChildren((OMContainer)this);
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }

    public void normalize(DOMConfigurationImpl config) {
        if (config.isEnabled(128)) {
            OMNamespace namespace = AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(this);
            if (namespace == null) {
                if (this.getDefaultNamespace() != null) {
                    this.declareDefaultNamespace("");
                }
            } else {
                OMNamespace namespaceForPrefix = this.findNamespaceURI(namespace.getPrefix());
                if (namespaceForPrefix == null || !namespaceForPrefix.getNamespaceURI().equals(namespace.getNamespaceURI())) {
                    this.declareNamespace(namespace);
                }
            }
        }
        DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$normalize(this, config);
    }

    public final void setComplete(boolean complete) {
        DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetState(this, complete ? 1 : 0);
        ParentNode parentNode = (ParentNode)CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(this);
        if (parentNode != null) {
            if (!complete) {
                ((DOMContainer)((Object)parentNode)).setComplete(false);
            } else {
                DOMContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$notifyChildComplete((DOMContainer)((Object)parentNode));
            }
        }
    }

    public final void build() {
        AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$defaultBuild(this);
    }

    public final void checkChild(OMNode child) {
    }

    public /* synthetic */ OMNamespace ajc$interFieldGet$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$namespace() {
        return this.namespace;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$namespace(OMNamespace oMNamespace) {
        this.namespace = oMNamespace;
    }

    public /* synthetic */ String ajc$interFieldGet$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$localName() {
        return this.localName;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$localName(String string) {
        this.localName = string;
    }

    public /* synthetic */ QName ajc$interFieldGet$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$qName() {
        return this.qName;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$qName(QName qName) {
        this.qName = qName;
    }

    public /* synthetic */ OMXMLParserWrapper ajc$interFieldGet$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$builder() {
        return this.builder;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$builder(OMXMLParserWrapper oMXMLParserWrapper) {
        this.builder = oMXMLParserWrapper;
    }

    public /* synthetic */ CoreParentNode ajc$interFieldGet$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$owner() {
        return this.owner;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$owner(CoreParentNode coreParentNode) {
        this.owner = coreParentNode;
    }

    public /* synthetic */ CoreChildNode ajc$interFieldGet$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$nextSibling() {
        return this.nextSibling;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$nextSibling(CoreChildNode coreChildNode) {
        this.nextSibling = coreChildNode;
    }

    public /* synthetic */ CoreChildNode ajc$interFieldGet$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$previousSibling() {
        return this.previousSibling;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$previousSibling(CoreChildNode coreChildNode) {
        this.previousSibling = coreChildNode;
    }

    public void addChild(OMNode oMNode) {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$addChild(this, oMNode);
    }

    public void addChild(OMNode oMNode, boolean bl) {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$addChild(this, oMNode, bl);
    }

    public /* synthetic */ CoreNode ajc$interMethodDispatch2$org_apache_axiom_core$getRootOrOwnerDocument() {
        return CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$getRootOrOwnerDocument(this);
    }

    public /* synthetic */ String ajc$interMethodDispatch2$org_apache_axiom_dom_DOMElementSupport$lookupPrefix(String string, Element element) {
        return DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$lookupPrefix(this, string, element);
    }

    public /* synthetic */ void ajc$interMethodDispatch2$org_apache_axiom_om_impl_dom$notifyChildComplete() {
        DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$notifyChildComplete(this);
    }

    public /* synthetic */ NodeList ajc$interMethodDispatch2$org_apache_axiom_om_impl_dom_DOMContainerSupport$getElementsWildcard() {
        return DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$getElementsWildcard(this);
    }

    public void close(boolean bl) {
        AxiomSerializableSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomSerializableSupport$org_apache_axiom_om_impl_common_AxiomSerializable$close(this, bl);
    }

    public final void coreDetach(CoreDocument coreDocument) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreDetach(this, coreDocument);
    }

    public final CoreChildNode coreGetNextSibling() throws OMException {
        return CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetNextSibling(this);
    }

    public final CoreChildNode coreGetNextSiblingIfAvailable() {
        return CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetNextSiblingIfAvailable(this);
    }

    public final NodeFactory coreGetNodeFactory() {
        return AxiomInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomInformationItemSupport$org_apache_axiom_om_impl_common_AxiomInformationItem$coreGetNodeFactory(this);
    }

    public final CoreParentNode coreGetParent() {
        return CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(this);
    }

    public final CoreChildNode coreGetPreviousSibling() {
        return CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetPreviousSibling(this);
    }

    public final boolean coreHasParent() {
        return CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreHasParent(this);
    }

    public final void coreInsertSiblingAfter(CoreChildNode coreChildNode) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingAfter(this, coreChildNode);
    }

    public final void coreInsertSiblingBefore(CoreChildNode coreChildNode) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingBefore(this, coreChildNode);
    }

    public final void coreInsertSiblingsBefore(CoreDocumentFragment coreDocumentFragment) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingsBefore(this, coreDocumentFragment);
    }

    public final void coreSetBuilder(OMXMLParserWrapper oMXMLParserWrapper) {
        DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetBuilder(this, oMXMLParserWrapper);
    }

    public final void coreSetNextSibling(CoreChildNode coreChildNode) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetNextSibling(this, coreChildNode);
    }

    public final void coreSetOwnerDocument(CoreDocument coreDocument) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetOwnerDocument(this, coreDocument);
    }

    public final void coreSetPreviousSibling(CoreChildNode coreChildNode) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetPreviousSibling(this, coreChildNode);
    }

    public final void coreSetState(int n) {
        DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetState(this, n);
    }

    public void defaultBuild() {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$defaultBuild(this);
    }

    public OMNode detach() {
        return AxiomChildNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomChildNodeSupport$org_apache_axiom_om_impl_common_AxiomChildNode$detach(this);
    }

    public void detachAndDiscardParent() {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$detachAndDiscardParent(this);
    }

    public void discard() {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$discard(this);
    }

    public final void discarded() {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$discarded(this);
    }

    public void forceExpand() {
        DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$forceExpand(this);
    }

    public final OMXMLParserWrapper getBuilder() {
        return DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$getBuilder(this);
    }

    public final Iterator getChildElements() {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getChildElements(this);
    }

    public Iterator getChildren() {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_OMContainer$getChildren((OMContainer)this);
    }

    public Iterator getChildrenWithLocalName(String string) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_OMContainer$getChildrenWithLocalName((OMContainer)this, string);
    }

    public Iterator getChildrenWithName(QName qName) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_OMContainer$getChildrenWithName((OMContainer)this, qName);
    }

    public Iterator getChildrenWithNamespaceURI(String string) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_OMContainer$getChildrenWithNamespaceURI((OMContainer)this, string);
    }

    public Iterator getDescendants(boolean bl) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_OMContainer$getDescendants((OMContainer)this, bl);
    }

    public final NodeList getElementsByTagName(String string) {
        return DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$getElementsByTagName(this, string);
    }

    public final NodeList getElementsByTagNameNS(String string, String string2) {
        return DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$getElementsByTagNameNS(this, string, string2);
    }

    public OMElement getFirstChildWithName(QName qName) throws OMException {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getFirstChildWithName(this, qName);
    }

    public final OMElement getFirstElement() {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getFirstElement(this);
    }

    public OMNode getFirstOMChild() {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getFirstOMChild(this);
    }

    public OMNode getFirstOMChildIfAvailable() {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getFirstOMChildIfAvailable(this);
    }

    public String getLocalName() {
        return AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getLocalName(this);
    }

    public OMNamespace getNamespace() {
        return AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(this);
    }

    public NamespaceContext getNamespaceContext(boolean bl) {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getNamespaceContext(this, bl);
    }

    public final Iterator getNamespacesInScope() {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getNamespacesInScope(this);
    }

    public OMNode getNextOMSibling() {
        return AxiomChildNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomChildNodeSupport$org_apache_axiom_om_impl_common_AxiomChildNode$getNextOMSibling(this);
    }

    public OMNode getNextOMSiblingIfAvailable() {
        return AxiomChildNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomChildNodeSupport$org_apache_axiom_om_impl_common_AxiomChildNode$getNextOMSiblingIfAvailable(this);
    }

    public final Node getNextSibling() {
        return DOMChildNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMChildNodeSupport$org_apache_axiom_dom_DOMChildNode$getNextSibling(this);
    }

    public final String getNodeName() {
        return DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$getNodeName(this);
    }

    public final short getNodeType() {
        return DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$getNodeType(this);
    }

    public String getNodeValue() {
        return DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$getNodeValue(this);
    }

    public final OMContainer getParent() {
        return AxiomChildNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomChildNodeSupport$org_apache_axiom_om_impl_common_AxiomChildNode$getParent(this);
    }

    public final Node getParentNode() {
        return DOMChildNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMChildNodeSupport$org_apache_axiom_dom_DOMChildNode$getParentNode(this);
    }

    public final String getPrefix() {
        return AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getPrefix(this);
    }

    public final OMNode getPreviousOMSibling() {
        return AxiomChildNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomChildNodeSupport$org_apache_axiom_om_impl_common_AxiomChildNode$getPreviousOMSibling(this);
    }

    public final Node getPreviousSibling() {
        return DOMChildNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMChildNodeSupport$org_apache_axiom_dom_DOMChildNode$getPreviousSibling(this);
    }

    public QName getQName() {
        return AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getQName(this);
    }

    public SAXResult getSAXResult() {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getSAXResult(this);
    }

    public final SAXSource getSAXSource(boolean bl) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getSAXSource(this, bl);
    }

    public final TypeInfo getSchemaTypeInfo() {
        return DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$getSchemaTypeInfo(this);
    }

    public int getState() {
        return DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$getState(this);
    }

    public String getText() {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getText(this);
    }

    public QName getTextAsQName() {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getTextAsQName(this);
    }

    public Reader getTextAsStream(boolean bl) {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getTextAsStream(this, bl);
    }

    public final int getType() {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getType(this);
    }

    public XMLStreamReader getXMLStreamReader() {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getXMLStreamReader(this);
    }

    public XMLStreamReader getXMLStreamReader(boolean bl) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getXMLStreamReader(this, bl);
    }

    public XMLStreamReader getXMLStreamReader(boolean bl, OMXMLStreamReaderConfiguration oMXMLStreamReaderConfiguration) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getXMLStreamReader(this, bl, oMXMLStreamReaderConfiguration);
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$getXMLStreamReaderWithoutCaching(this);
    }

    public final OMNamespace handleNamespace(String string, String string2) {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$handleNamespace(this, string, string2);
    }

    public final OMNamespace handleNamespace(AxiomElement axiomElement, OMNamespace oMNamespace, boolean bl, boolean bl2) {
        return AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$handleNamespace(this, axiomElement, oMNamespace, bl, bl2);
    }

    public boolean hasName(QName qName) {
        return AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$hasName(this, qName);
    }

    public void insertChild(Class[] classArray, int n, OMNode oMNode) {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$insertChild(this, classArray, n, oMNode);
    }

    public final void insertSiblingAfter(OMNode oMNode) throws OMException {
        AxiomChildNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomChildNodeSupport$org_apache_axiom_om_impl_common_AxiomChildNode$insertSiblingAfter(this, oMNode);
    }

    public final void insertSiblingBefore(OMNode oMNode) throws OMException {
        AxiomChildNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomChildNodeSupport$org_apache_axiom_om_impl_common_AxiomChildNode$insertSiblingBefore(this, oMNode);
    }

    public final String internalGetLocalName() {
        return AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalGetLocalName(this);
    }

    public final void internalSetLocalName(String string) {
        AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(this, string);
    }

    public final void internalSetNamespace(OMNamespace oMNamespace) {
        AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetNamespace(this, oMNamespace);
    }

    public void internalSetParent(CoreParentNode coreParentNode) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$internalSetParent(this, coreParentNode);
    }

    public final void internalUnsetParent(CoreDocument coreDocument) {
        CoreChildNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$internalUnsetParent(this, coreDocument);
    }

    public boolean isComplete() {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$isComplete(this);
    }

    public final String lookupNamespaceURI(String string) {
        return DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$lookupNamespaceURI(this, string);
    }

    public final String lookupPrefix(String string) {
        return DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$lookupPrefix(this, string);
    }

    public final AxiomChildNode prepareNewChild(OMNode oMNode) {
        return AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$prepareNewChild(this, oMNode);
    }

    public void removeChildren() {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$removeChildren(this);
    }

    public final QName resolveQName(String string) {
        return AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$resolveQName(this, string);
    }

    public final void serialize(OutputStream outputStream) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serialize((AxiomContainer)this, outputStream);
    }

    public final void serialize(OutputStream outputStream, OMOutputFormat oMOutputFormat) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serialize((AxiomContainer)this, outputStream, oMOutputFormat);
    }

    public final void serialize(Writer writer) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serialize((AxiomContainer)this, writer);
    }

    public final void serialize(Writer writer, OMOutputFormat oMOutputFormat) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serialize((AxiomContainer)this, writer, oMOutputFormat);
    }

    public final void serialize(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        AxiomSerializableSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomSerializableSupport$org_apache_axiom_om_impl_common_AxiomSerializable$serialize(this, xMLStreamWriter);
    }

    public final void serialize(XMLStreamWriter xMLStreamWriter, boolean bl) throws XMLStreamException {
        AxiomSerializableSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomSerializableSupport$org_apache_axiom_om_impl_common_AxiomSerializable$serialize(this, xMLStreamWriter, bl);
    }

    public final void serializeAndConsume(OutputStream outputStream) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serializeAndConsume((AxiomContainer)this, outputStream);
    }

    public final void serializeAndConsume(OutputStream outputStream, OMOutputFormat oMOutputFormat) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serializeAndConsume((AxiomContainer)this, outputStream, oMOutputFormat);
    }

    public final void serializeAndConsume(Writer writer) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serializeAndConsume((AxiomContainer)this, writer);
    }

    public final void serializeAndConsume(Writer writer, OMOutputFormat oMOutputFormat) throws XMLStreamException {
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$serializeAndConsume((AxiomContainer)this, writer, oMOutputFormat);
    }

    public final void serializeAndConsume(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        AxiomSerializableSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomSerializableSupport$org_apache_axiom_om_impl_common_AxiomSerializable$serializeAndConsume(this, xMLStreamWriter);
    }

    public void setLocalName(String string) {
        AxiomNamedInformationItemSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$setLocalName(this, string);
    }

    public void setNamespace(OMNamespace oMNamespace, boolean bl) {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$setNamespace(this, oMNamespace, bl);
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace oMNamespace) {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$setNamespaceWithNoFindInCurrentScope(this, oMNamespace);
    }

    public void setNodeValue(String string) {
        DOMElementSupport.ajc$interMethod$org_apache_axiom_dom_DOMElementSupport$org_apache_axiom_dom_DOMElement$setNodeValue(this, string);
    }

    public final void setPrefix(String string) throws DOMException {
        NamedNodeSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_NamedNodeSupport$org_apache_axiom_om_impl_dom_NamedNode$setPrefix(this, string);
    }

    public void setText(String string) {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$setText((AxiomElement)this, string);
    }

    public final void setText(QName qName) {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$setText((AxiomElement)this, qName);
    }

    public void writeTextTo(Writer writer, boolean bl) throws IOException {
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$writeTextTo(this, writer, bl);
    }
}

