/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.om.impl.dom.XMLChar;

class DOMUtil {
    DOMUtil() {
    }

    public static boolean isQualifiedName(String value) {
        return true;
    }

    private static void validateName(String namespaceURI, String localName, String prefix) {
        if (prefix != null && !XMLChar.isValidNCName(prefix) || !XMLChar.isValidNCName(localName)) {
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        if (namespaceURI == null && prefix != null || "xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
    }

    public static void validateElementName(String namespaceURI, String localName, String prefix) {
        DOMUtil.validateName(namespaceURI, localName, prefix);
    }

    public static void validateAttrName(String namespaceURI, String localName, String prefix) {
        DOMUtil.validateName(namespaceURI, localName, prefix);
        if ("xmlns".equals(prefix != null ? prefix : localName) != "http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
    }

    public static String getLocalName(String qualifiedName) {
        int idx = qualifiedName.indexOf(58);
        if (idx == -1) {
            return qualifiedName;
        }
        if (qualifiedName.indexOf(58, idx + 1) == -1) {
            return qualifiedName.substring(idx + 1);
        }
        throw DOMExceptionUtil.newDOMException((short)14);
    }

    public static String getPrefix(String qualifiedName) {
        int idx = qualifiedName.indexOf(58);
        if (idx == -1) {
            return null;
        }
        if (idx == 0 || idx == qualifiedName.length() - 1) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
        return qualifiedName.substring(0, idx);
    }
}

