/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.wookie.w3c.IContent;
import org.apache.wookie.w3c.IIcon;
import org.apache.wookie.w3c.W3CWidget;
import org.apache.wookie.w3c.util.WidgetPackageUtils;
import org.apache.wookie.w3c.xml.IElement;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class WidgetOutputter {
    private String widgetFolder;

    public void outputXML(W3CWidget widget, File file) throws IOException {
        Document doc = this.createWidgetDocument(widget);
        XMLOutputter out = new XMLOutputter();
        FileOutputStream fos = new FileOutputStream(file);
        out.output(doc, (OutputStream)fos);
    }

    public void outputXML(W3CWidget widget, OutputStream out) throws IOException {
        Document doc = this.createWidgetDocument(widget);
        XMLOutputter outputter = new XMLOutputter();
        outputter.output(doc, out);
    }

    public String outputXMLString(W3CWidget widget) {
        Document doc = this.createWidgetDocument(widget);
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(doc);
    }

    private Document createWidgetDocument(W3CWidget widget) {
        widget = this.replacePaths(widget);
        return new Document(((IElement)((Object)widget)).toXml());
    }

    private W3CWidget replacePaths(W3CWidget widget) {
        String src;
        String folder = WidgetPackageUtils.convertIdToFolderName(widget.getIdentifier());
        String installedPath = this.widgetFolder + "/" + folder + "/";
        W3CWidget localWidget = widget;
        for (IContent content : localWidget.getContentList()) {
            src = content.getSrc();
            src = src.replace(installedPath, "");
            content.setSrc(src);
        }
        for (IIcon icon : localWidget.getIcons()) {
            src = icon.getSrc();
            src = src.replace(installedPath, "");
            icon.setSrc(src);
        }
        return localWidget;
    }

    public void setWidgetFolder(String widgetFolder) {
        this.widgetFolder = widgetFolder;
    }
}

