/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.updates;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.wookie.w3c.impl.AbstractLocalizedEntity;
import org.apache.wookie.w3c.updates.InvalidUDDException;
import org.apache.wookie.w3c.util.LocalizationUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class UpdateDescriptionDocument {
    private URL updateSource;
    private String versionTag;
    private ArrayList<Details> details;
    private URL baseUrl;

    public String getDetails(String locale) {
        Details localDetails = (Details)LocalizationUtils.getLocalizedElement(this.details.toArray(new Details[this.details.size()]), new String[]{locale}, null);
        return localDetails.text;
    }

    public URL getUpdateSource() {
        return this.updateSource;
    }

    public String getVersionTag() {
        return this.versionTag;
    }

    public UpdateDescriptionDocument(String details, URL updateSource, String versionTag) {
        this.details = new ArrayList();
        Details d = new Details();
        d.text = details;
        this.details.add(d);
        this.updateSource = updateSource;
        this.versionTag = versionTag;
    }

    public UpdateDescriptionDocument(String href) throws InvalidUDDException {
        try {
            this.baseUrl = new URL(href);
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(this.baseUrl.toString());
            method.setFollowRedirects(true);
            client.executeMethod((HttpMethod)method);
            String type = method.getResponseHeader("Content-Type").getValue();
            int code = method.getStatusCode();
            if (code != 200) {
                throw new InvalidUDDException("Bad HTTP response from update site: " + code);
            }
            if (!type.equals("application/xml")) {
                throw new InvalidUDDException("Bad content type in response from update site: " + type);
            }
            Document doc = new SAXBuilder().build(method.getResponseBodyAsStream());
            this.fromXML(doc);
        }
        catch (Exception e) {
            if (e instanceof InvalidUDDException) {
                throw (InvalidUDDException)e;
            }
            throw new InvalidUDDException("the document is not a valid UDD");
        }
    }

    public void fromXML(Document document) throws InvalidUDDException {
        Element root;
        if (document == null) {
            throw new InvalidUDDException("No document found");
        }
        try {
            root = document.getRootElement();
        }
        catch (Exception e1) {
            throw new InvalidUDDException("Root element must be <update-info>");
        }
        if (!root.getName().equals("update-info")) {
            throw new InvalidUDDException("Root element must be <update-info>");
        }
        if (root.getNamespace() != Namespace.getNamespace((String)"http://www.w3.org/ns/widgets")) {
            throw new InvalidUDDException("Wrong namespace for Update Description Document");
        }
        if (root.getAttribute("version") == null) {
            throw new InvalidUDDException("no version attribute");
        }
        if (root.getAttribute("src") == null) {
            throw new InvalidUDDException("no src attribute");
        }
        this.versionTag = root.getAttributeValue("version");
        try {
            this.updateSource = new URL(root.getAttributeValue("src"));
        }
        catch (MalformedURLException e) {
            try {
                this.updateSource = new URL(this.baseUrl, root.getAttributeValue("src"));
            }
            catch (MalformedURLException e1) {
                throw new InvalidUDDException("src attribute is not a valid URL");
            }
        }
        List detailsElements = root.getChildren("details", Namespace.getNamespace((String)"http://www.w3.org/ns/widgets"));
        this.details = new ArrayList();
        for (Object o : detailsElements) {
            Details detailsItem = new Details();
            detailsItem.fromXML((Element)o);
            this.details.add(detailsItem);
        }
    }

    public Element toXml() {
        Element element = new Element("update-info", "http://www.w3.org/ns/widgets");
        element.setAttribute("version", this.getVersionTag());
        element.setAttribute("src", this.getUpdateSource().toString());
        for (Details details : this.details) {
            element.addContent((Content)details.toXml());
        }
        return element;
    }

    static class Details
    extends AbstractLocalizedEntity {
        public String text;

        public void fromXML(Element element) {
            super.fromXML(element);
            this.text = Details.getLocalizedTextContent(element);
        }

        public Element toXml() {
            Element element = new Element("details", "http://www.w3.org/ns/widgets");
            element.setText(this.text);
            element = this.setLocalisationAttributes(element);
            return element;
        }
    }
}

