/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.wookie.w3c.IIconEntity;
import org.apache.wookie.w3c.exceptions.BadManifestException;
import org.apache.wookie.w3c.impl.AbstractLocalizedEntity;
import org.apache.wookie.w3c.util.ContentTypeUtils;
import org.apache.wookie.w3c.util.NumberUtils;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.apache.wookie.w3c.util.WidgetPackageUtils;
import org.jdom.Element;

public class IconEntity
extends AbstractLocalizedEntity
implements IIconEntity {
    private String fSrc;
    private Integer fHeight;
    private Integer fWidth;

    public IconEntity() {
        this.fSrc = "";
        this.fHeight = null;
        this.fWidth = null;
    }

    public IconEntity(String src, Integer height, Integer width) {
        this.fSrc = src;
        this.fHeight = height;
        this.fWidth = width;
    }

    public String getSrc() {
        return this.fSrc;
    }

    public void setSrc(String src) {
        this.fSrc = src;
    }

    public Integer getHeight() {
        return this.fHeight;
    }

    public void setHeight(Integer height) {
        this.fHeight = height;
    }

    public Integer getWidth() {
        return this.fWidth;
    }

    public void setWidth(Integer width) {
        this.fWidth = width;
    }

    public void fromXML(Element element) {
    }

    public void fromXML(Element element, String[] locales, ZipFile zip) throws BadManifestException {
        String width;
        this.fSrc = UnicodeUtils.normalizeSpaces(element.getAttributeValue("src"));
        try {
            this.fSrc = WidgetPackageUtils.locateFilePath(this.fSrc, locales, zip);
            this.setLang(WidgetPackageUtils.languageTagForPath(this.fSrc));
        }
        catch (Exception e) {
            this.fSrc = null;
        }
        try {
            if (!ContentTypeUtils.isSupportedImageType(this.fSrc)) {
                this.fSrc = null;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String height = element.getAttributeValue("height");
        if (height != null) {
            try {
                this.fHeight = NumberUtils.processNonNegativeInteger(height);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((width = element.getAttributeValue("width")) != null) {
            try {
                this.fWidth = NumberUtils.processNonNegativeInteger(width);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public Element toXml() {
        Element element = new Element("icon", "http://www.w3.org/ns/widgets");
        element.setAttribute("src", this.getSrc());
        if (this.getHeight() != null && this.getHeight() > 0) {
            element.setAttribute("height", String.valueOf(this.getHeight()));
        }
        if (this.getWidth() != null && this.getWidth() > 0) {
            element.setAttribute("width", String.valueOf(this.getWidth()));
        }
        return element;
    }
}

