/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wookie.w3c.IContentEntity;
import org.apache.wookie.w3c.IStartPageProcessor;
import org.apache.wookie.w3c.W3CWidget;
import org.apache.wookie.w3c.exceptions.BadManifestException;
import org.apache.wookie.w3c.exceptions.BadWidgetZipFileException;
import org.apache.wookie.w3c.exceptions.InvalidContentTypeException;
import org.apache.wookie.w3c.exceptions.InvalidStartFileException;
import org.apache.wookie.w3c.impl.WidgetManifestModel;
import org.apache.wookie.w3c.util.WidgetPackageUtils;

public class W3CWidgetFactory {
    static Logger _logger = Logger.getLogger((String)W3CWidgetFactory.class.getName());
    private File unzippedWidgetDirectory;
    private File outputDirectory = null;
    private IStartPageProcessor startPageProcessor;
    private String[] locales = new String[]{"en"};
    private String localPath = "/widgets";
    private String[] features = new String[0];
    private String[] encodings = new String[]{"UTF-8"};
    private static final String WIDGET_CONTENT_TYPE = "application/widget";

    public void setFeatures(String[] features) {
        this.features = features;
    }

    public W3CWidgetFactory() {
        this.startPageProcessor = new IStartPageProcessor(){

            public void processStartFile(File startFile, W3CWidget model, IContentEntity content) throws Exception {
            }
        };
    }

    public void setOutputDirectory(String outputDirectory) throws IOException {
        if (outputDirectory == null) {
            throw new NullPointerException();
        }
        File file = new File(outputDirectory);
        if (!file.exists()) {
            throw new FileNotFoundException("the output directory does not exist");
        }
        if (!file.canWrite()) {
            throw new IOException("the output directory cannot be written to");
        }
        if (!file.isDirectory()) {
            throw new IOException("the output directory is not a folder");
        }
        this.outputDirectory = file;
    }

    public void setStartPageProcessor(IStartPageProcessor startPageProcessor) {
        this.startPageProcessor = startPageProcessor;
    }

    public void setLocales(String[] locales) {
        if (locales == null) {
            throw new NullPointerException("locales cannot be specified as Null");
        }
        this.locales = locales;
    }

    public void setLocalPath(String localPath) {
        if (localPath == null) {
            throw new NullPointerException("local path cannot be set to Null");
        }
        this.localPath = localPath;
    }

    public W3CWidget parse(File zipFile) throws Exception, BadWidgetZipFileException, BadManifestException {
        if (this.outputDirectory == null) {
            throw new Exception("No output directory has been set; use setOutputDirectory(File) to set the location to output widget files");
        }
        return this.processWidgetPackage(zipFile, null);
    }

    public W3CWidget parse(File zipFile, String defaultIdentifier) throws Exception, BadWidgetZipFileException, BadManifestException {
        if (this.outputDirectory == null) {
            throw new Exception("No output directory has been set; use setOutputDirectory(File) to set the location to output widget files");
        }
        return this.processWidgetPackage(zipFile, defaultIdentifier);
    }

    public W3CWidget parse(URL url) throws BadWidgetZipFileException, BadManifestException, InvalidContentTypeException, IOException, Exception {
        File file = this.download(url, false);
        return this.parse(file);
    }

    public W3CWidget parse(URL url, boolean ignoreContentType) throws BadWidgetZipFileException, BadManifestException, InvalidContentTypeException, IOException, Exception {
        File file = this.download(url, ignoreContentType);
        return this.parse(file);
    }

    public W3CWidget parse(URL url, boolean ignoreContentType, String defaultIdentifier) throws BadWidgetZipFileException, BadManifestException, InvalidContentTypeException, IOException, Exception {
        File file = this.download(url, ignoreContentType);
        return this.parse(file, defaultIdentifier);
    }

    private File download(URL url, boolean ignoreContentType) throws InvalidContentTypeException, HttpException, IOException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url.toString());
        client.executeMethod((HttpMethod)method);
        String type = method.getResponseHeader("Content-Type").getValue();
        if (!ignoreContentType && !type.startsWith(WIDGET_CONTENT_TYPE)) {
            throw new InvalidContentTypeException("Problem downloading widget: expected a content type of application/widget but received:" + type);
        }
        File file = File.createTempFile("wookie", null);
        FileUtils.writeByteArrayToFile((File)file, (byte[])IOUtils.toByteArray((InputStream)method.getResponseBodyAsStream()));
        method.releaseConnection();
        return file;
    }

    public void setEncodings(String[] encodings) throws Exception {
        if (encodings == null) {
            throw new NullPointerException("Supported encodings cannot be set to null");
        }
        if (encodings.length == 0) {
            throw new Exception("At least one encoding must be specified");
        }
        this.encodings = encodings;
    }

    private W3CWidget processWidgetPackage(File zipFile, String defaultIdentifier) throws BadWidgetZipFileException, BadManifestException {
        ZipFile zip;
        try {
            zip = new ZipFile(zipFile);
        }
        catch (IOException e) {
            throw new BadWidgetZipFileException();
        }
        if (WidgetPackageUtils.hasManifest(zip)) {
            try {
                WidgetManifestModel widgetModel = new WidgetManifestModel(WidgetPackageUtils.extractManifest(zip), this.locales, this.features, this.encodings, zip, defaultIdentifier);
                String manifestIdentifier = widgetModel.getIdentifier();
                this.unzippedWidgetDirectory = WidgetPackageUtils.createUnpackedWidgetFolder(this.outputDirectory, manifestIdentifier);
                WidgetPackageUtils.unpackZip(zip, this.unzippedWidgetDirectory);
                for (IContentEntity content : widgetModel.getContentList()) {
                    File startFile = new File(this.unzippedWidgetDirectory.getCanonicalPath() + File.separator + content.getSrc());
                    String relativestartUrl = WidgetPackageUtils.getURLForWidget(this.localPath, manifestIdentifier, content.getSrc());
                    content.setSrc(relativestartUrl);
                    if (!startFile.exists() || this.startPageProcessor == null) continue;
                    this.startPageProcessor.processStartFile(startFile, widgetModel, content);
                }
                if (widgetModel.getContentList().isEmpty()) {
                    throw new InvalidStartFileException("Widget has no start page");
                }
                String thelocalPath = WidgetPackageUtils.getURLForWidget(this.localPath, manifestIdentifier, "");
                widgetModel.updateIconPaths(thelocalPath);
                return widgetModel;
            }
            catch (InvalidStartFileException e) {
                throw e;
            }
            catch (BadManifestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BadManifestException(e);
            }
        }
        throw new BadWidgetZipFileException();
    }

    public File getUnzippedWidgetDirectory() {
        return this.unzippedWidgetDirectory;
    }
}

