/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import org.apache.wookie.w3c.IName;
import org.apache.wookie.w3c.impl.AbstractLocalizedEntity;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.apache.wookie.w3c.xml.IElement;
import org.jdom.Element;

public class NameEntity
extends AbstractLocalizedEntity
implements IName,
IElement {
    private String fName;
    private String fShort;

    public NameEntity() {
        this.fName = "";
        this.fShort = "";
        this.setLang(null);
    }

    public NameEntity(String name, String short1, String language) {
        this.fName = name;
        this.fShort = short1;
        this.setLang(language);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getShort() {
        return this.fShort;
    }

    public void setShort(String short1) {
        this.fShort = short1;
    }

    public void fromXML(Element element) {
        super.fromXML(element);
        this.fName = NameEntity.getLocalizedTextContent(element);
        this.fShort = UnicodeUtils.normalizeSpaces(element.getAttributeValue("short"));
    }

    public Element toXml() {
        Element nameElem = new Element("name", "http://www.w3.org/ns/widgets");
        nameElem.setText(this.getName());
        if (this.getShort() != null && this.getShort().length() > 0) {
            nameElem.setAttribute("short", this.getShort());
        }
        nameElem = this.setLocalisationAttributes(nameElem);
        return nameElem;
    }
}

