/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wookie.w3c.IDirectional;
import org.apache.wookie.w3c.ILocalized;
import org.apache.wookie.w3c.util.LocalizationUtils;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.apache.wookie.w3c.xml.IElement;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

public abstract class AbstractLocalizedEntity
implements ILocalized,
IDirectional,
IElement {
    protected String lang;
    protected String dir;
    public static final String LEFT_TO_RIGHT = "ltr";
    public static final String RIGHT_TO_LEFT = "rtl";
    public static final String LEFT_TO_RIGHT_OVERRIDE = "lro";
    public static final String RIGHT_TO_LEFT_OVERRIDE = "rlo";

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public boolean isValid() {
        if (this.getLang() == null) {
            return true;
        }
        return LocalizationUtils.isValidLanguageTag(this.getLang());
    }

    public void fromXML(Element element) {
        String lang = UnicodeUtils.normalizeSpaces(element.getAttributeValue("lang", Namespace.XML_NAMESPACE));
        if (!lang.equals("")) {
            this.setLang(lang);
        }
        this.dir = AbstractLocalizedEntity.getTextDirection(element);
    }

    public static String getLocalizedTextContent(Element element) {
        StringBuffer content = new StringBuffer();
        for (Object node : element.getContent()) {
            if (node instanceof Element) {
                if ((((Element)node).getAttribute("dir") != null || ((Element)node).getAttribute("lang") != null) && ((Element)node).getName().equals("span")) {
                    content.append("<span dir=\"" + AbstractLocalizedEntity.getTextDirection((Element)node) + "\"");
                    if (((Element)node).getAttribute("lang") != null) {
                        content.append(" xml:lang=\"" + ((Element)node).getAttribute("lang").getValue() + "\"");
                    }
                    content.append(">");
                    content.append(AbstractLocalizedEntity.getLocalizedTextContent((Element)node));
                    content.append("</span>");
                } else {
                    content.append(AbstractLocalizedEntity.getLocalizedTextContent((Element)node));
                }
            }
            if (!(node instanceof Text)) continue;
            String text = ((Text)node).getText();
            content.append(StringEscapeUtils.unescapeXml((String)text));
        }
        return UnicodeUtils.normalizeWhitespace(content.toString());
    }

    public static String getTextDirection(Element element) {
        try {
            Attribute dir = element.getAttribute("dir");
            if (dir == null) {
                if (element.isRootElement()) {
                    return null;
                }
                return AbstractLocalizedEntity.getTextDirection(element.getParentElement());
            }
            String dirValue = UnicodeUtils.normalizeSpaces(dir.getValue());
            if (dirValue.equals(RIGHT_TO_LEFT)) {
                return RIGHT_TO_LEFT;
            }
            if (dirValue.equals(LEFT_TO_RIGHT)) {
                return LEFT_TO_RIGHT;
            }
            if (dirValue.equals(RIGHT_TO_LEFT_OVERRIDE)) {
                return RIGHT_TO_LEFT_OVERRIDE;
            }
            if (dirValue.equals(LEFT_TO_RIGHT_OVERRIDE)) {
                return LEFT_TO_RIGHT_OVERRIDE;
            }
            return AbstractLocalizedEntity.getTextDirection(element.getParentElement());
        }
        catch (Exception e) {
            return LEFT_TO_RIGHT;
        }
    }

    protected Element setLocalisationAttributes(Element element) {
        if (this.getDir() != null) {
            element.setAttribute("dir", this.getDir());
        }
        if (this.getLang() != null) {
            element.setAttribute("lang", this.getLang(), Namespace.XML_NAMESPACE);
        }
        return element;
    }
}

