/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.wookie.w3c.IContentEntity;
import org.apache.wookie.w3c.IW3CXMLConfiguration;
import org.apache.wookie.w3c.exceptions.BadManifestException;
import org.apache.wookie.w3c.exceptions.InvalidContentTypeException;
import org.apache.wookie.w3c.impl.AbstractLocalizedEntity;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.apache.wookie.w3c.util.WidgetPackageUtils;
import org.jdom.Element;

public class ContentEntity
extends AbstractLocalizedEntity
implements IContentEntity {
    private String fSrc;
    private String fCharSet;
    private String fType;

    public ContentEntity() {
        this.fSrc = "";
        this.fType = "";
    }

    public ContentEntity(String src, String charSet, String type) {
        this.fSrc = src;
        this.fCharSet = charSet;
        this.fType = type;
    }

    public String getSrc() {
        return this.fSrc;
    }

    public void setSrc(String src) {
        this.fSrc = src;
    }

    public String getCharSet() {
        return this.fCharSet;
    }

    public void setCharSet(String charSet) {
        this.fCharSet = charSet;
    }

    public String getType() {
        return this.fType;
    }

    public void setType(String type) {
        this.fType = type;
    }

    public void fromXML(Element element) {
    }

    public void fromXML(Element element, String[] locales, String[] encodings, ZipFile zip) throws BadManifestException {
        this.fSrc = UnicodeUtils.normalizeSpaces(element.getAttributeValue("src"));
        try {
            this.fSrc = WidgetPackageUtils.locateFilePath(this.fSrc, locales, zip);
            this.setLang(WidgetPackageUtils.languageTagForPath(this.fSrc));
        }
        catch (Exception e) {
            this.fSrc = null;
        }
        String charsetParameter = null;
        this.fType = UnicodeUtils.normalizeSpaces(element.getAttributeValue("type"));
        if (this.fType.equals("")) {
            this.fType = "text/html";
        } else {
            String[] type = this.fType.split(";");
            if (!this.isSupported(type[0], IW3CXMLConfiguration.SUPPORTED_CONTENT_TYPES)) {
                throw new InvalidContentTypeException("Content type is not supported");
            }
            this.fType = type[0];
            if (type.length > 1) {
                String[] charset = type[type.length - 1].split("=");
                charsetParameter = charset[charset.length - 1];
            }
        }
        String charset = UnicodeUtils.normalizeSpaces(element.getAttributeValue("encoding"));
        if (this.isSupported(charset, encodings)) {
            this.setCharSet(charset);
        }
        if (this.getCharSet() == null && this.isSupported(charsetParameter, encodings)) {
            this.setCharSet(charsetParameter);
        }
        if (this.getCharSet() == null) {
            this.setCharSet("UTF-8");
        }
    }

    private boolean isSupported(String value, String[] supportedValues) {
        if (value == null) {
            return false;
        }
        boolean supported = false;
        for (String type : supportedValues) {
            if (!StringUtils.equals((String)value, (String)type)) continue;
            supported = true;
        }
        return supported;
    }

    public Element toXml() {
        Element contentElem = new Element("content", "http://www.w3.org/ns/widgets");
        contentElem.setAttribute("src", this.getSrc());
        if (this.getType() != null) {
            contentElem.setAttribute("type", this.getType());
        }
        if (this.getCharSet() != null) {
            contentElem.setAttribute("encoding", this.getCharSet());
        }
        contentElem = this.setLocalisationAttributes(contentElem);
        return contentElem;
    }
}

