/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import org.apache.wookie.w3c.IAuthorEntity;
import org.apache.wookie.w3c.impl.AbstractLocalizedEntity;
import org.apache.wookie.w3c.util.IRIValidator;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.jdom.Element;

public class AuthorEntity
extends AbstractLocalizedEntity
implements IAuthorEntity {
    private String fAuthorName;
    private String fHref;
    private String fEmail;

    public AuthorEntity() {
        this.fAuthorName = "";
        this.fHref = "";
        this.fEmail = "";
    }

    public AuthorEntity(String authorName, String href, String email) {
        this.fAuthorName = authorName;
        this.fHref = href;
        this.fEmail = email;
    }

    public String getAuthorName() {
        return this.fAuthorName;
    }

    public void setAuthorName(String authorName) {
        this.fAuthorName = authorName;
    }

    public String getHref() {
        return this.fHref;
    }

    public void setHref(String href) {
        this.fHref = href;
    }

    public String getEmail() {
        return this.fEmail;
    }

    public void setEmail(String email) {
        this.fEmail = email;
    }

    public void fromXML(Element element) {
        super.fromXML(element);
        this.fAuthorName = AuthorEntity.getLocalizedTextContent(element);
        this.fHref = UnicodeUtils.normalizeSpaces(element.getAttributeValue("href"));
        if (this.fHref.equals("")) {
            this.fHref = null;
        }
        if (!IRIValidator.isValidIRI(this.fHref)) {
            this.fHref = null;
        }
        this.fEmail = UnicodeUtils.normalizeSpaces(element.getAttributeValue("email"));
        if (this.fEmail.equals("")) {
            this.fEmail = null;
        }
    }

    public Element toXml() {
        Element element = new Element("author", "http://www.w3.org/ns/widgets");
        element.setText(this.getAuthorName());
        if (this.getHref() != null && this.getHref().length() > 0) {
            element.setAttribute("href", this.getHref());
        }
        if (this.getEmail() != null && this.getEmail().length() > 0) {
            element.setAttribute("email", this.getEmail());
        }
        element = this.setLocalisationAttributes(element);
        return element;
    }
}

