/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.spring.internal;

import javax.ws.rs.WebApplicationException;
import org.apache.wink.common.internal.lifecycle.CreationUtils;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.runtime.RuntimeContext;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.spring.internal.SpringLifecycleManager;
import org.apache.wink.spring.internal.SpringObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesInjectionPostProcessor
implements BeanPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DependenciesInjectionPostProcessor.class);
    private SpringLifecycleManager<Object> springOFFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        SpringObjectFactory springObjectFactory = this.springOFFactory.getSpringObjectFactory(bean, beanName);
        if (springObjectFactory != null) {
            ClassMetadata classMetadata = springObjectFactory.getClassMetadata();
            try {
                CreationUtils.injectFields((Object)bean, (ClassMetadata)classMetadata, (RuntimeContext)RuntimeContextTLS.getRuntimeContext());
            }
            catch (Exception e) {
                logger.error("Exception occured during the fields injection for bean " + beanName, (Throwable)e);
                throw new WebApplicationException((Throwable)e);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setSpringOFFactory(SpringLifecycleManager<Object> springOFFactory) {
        this.springOFFactory = springOFFactory;
    }
}

