/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.velocity;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.velocity.app.Velocity;
import org.apache.wicket.Application;
import org.apache.wicket.IInitializer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.file.WebApplicationPath;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer
implements IInitializer {
    private static final Logger log = LoggerFactory.getLogger(Initializer.class);

    public void init(Application application) {
        Properties props = this.getVelocityProperties(application);
        try {
            if (null != props) {
                Velocity.init((Properties)props);
            } else {
                Velocity.init();
            }
            log.info("Initialized Velocity successfully");
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    private Properties getVelocityProperties(Application application) {
        String velocityPropertiesFile = "velocity.properties";
        if (application instanceof WebApplication) {
            WebApplication webapp = (WebApplication)application;
            ServletContext servletContext = webapp.getServletContext();
            String propertiesFolder = servletContext.getInitParameter("velocityPropertiesFolder");
            String propsFile = servletContext.getInitParameter("velocity.properties");
            if (null != propsFile) {
                velocityPropertiesFile = propsFile;
            }
            if (null != propertiesFolder) {
                WebApplicationPath webPath = new WebApplicationPath(servletContext);
                webPath.add(propertiesFolder);
                IResourceStream stream = webPath.find(Initializer.class, velocityPropertiesFile);
                InputStream is = null;
                try {
                    is = stream.getInputStream();
                    Properties props = new Properties();
                    props.load(is);
                    Properties properties = props;
                    return properties;
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                catch (ResourceStreamNotFoundException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                finally {
                    try {
                        IOUtils.close((Closeable)is);
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        InputStream is = Initializer.class.getResourceAsStream("velocity.properties");
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        finally {
            try {
                IOUtils.close((Closeable)is);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void destroy(Application application) {
    }
}

