/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.velocity.app.Velocity;
import org.apache.wicket.Application;
import org.apache.wicket.IInitializer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.file.WebApplicationPath;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer
implements IInitializer {
    private static final Logger log = LoggerFactory.getLogger((Class)Initializer.class);
    private String velocityPropertiesFile = "velocity.properties";
    private String velocityPropertiesFolder;

    public void init(Application application) {
        Properties props = this.getVelocityProperties(application);
        try {
            if (null != props) {
                Velocity.init((Properties)props);
            } else {
                Velocity.init();
            }
            log.info("Initialized Velocity successfully");
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    private Properties getVelocityProperties(Application application) {
        if (application instanceof WebApplication) {
            ServletContext servletContext;
            WebApplication webapp = (WebApplication)application;
            ServletContext sc = servletContext = webapp.getServletContext();
            this.velocityPropertiesFolder = sc.getInitParameter("velocityPropertiesFolder");
            String propsFile = servletContext.getInitParameter("velocity.properties");
            if (null != propsFile) {
                this.velocityPropertiesFile = propsFile;
            }
            if (null != this.velocityPropertiesFolder) {
                WebApplicationPath webPath = new WebApplicationPath(sc);
                webPath.add(this.velocityPropertiesFolder);
                IResourceStream stream = webPath.find(Initializer.class, this.velocityPropertiesFile);
                InputStream is = null;
                try {
                    is = stream.getInputStream();
                    Properties props = new Properties();
                    props.load(is);
                    Properties properties = props;
                    return properties;
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                catch (ResourceStreamNotFoundException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        InputStream is = Initializer.class.getResourceAsStream("velocity.properties");
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

