/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.velocity.markup.html;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupParser;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.IStringResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.Strings;

public abstract class VelocityPanel
extends Panel {
    public static VelocityPanel forTemplateResource(String id, IModel model, final IStringResourceStream templateResource) {
        if (templateResource == null) {
            throw new IllegalArgumentException("argument templateResource must be not null");
        }
        return new VelocityPanel(id, model){

            protected IStringResourceStream getTemplateResource() {
                return templateResource;
            }
        };
    }

    public VelocityPanel(String id, IModel model) {
        super(id, model);
    }

    private Reader getTemplateReader() {
        IStringResourceStream resource = this.getTemplateResource();
        if (resource == null) {
            throw new IllegalArgumentException("getTemplateResource must return a resource");
        }
        String template = resource.asString();
        if (template != null) {
            return new StringReader(template);
        }
        return null;
    }

    private void onException(Exception exception, MarkupStream markupStream, ComponentTag openTag) {
        if (this.throwVelocityExceptions()) {
            throw new WicketRuntimeException((Throwable)exception);
        }
        String stackTraceAsString = Strings.toString((Throwable)exception);
        this.replaceComponentTagBody(markupStream, openTag, stackTraceAsString);
    }

    protected boolean escapeHtml() {
        return false;
    }

    protected abstract IStringResourceStream getTemplateResource();

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        block11: {
            Reader templateReader = this.getTemplateReader();
            if (templateReader != null) {
                Map map = (Map)this.getModelObject();
                VelocityContext ctx = new VelocityContext(map);
                StringWriter writer = new StringWriter();
                String logTag = this.getId();
                try {
                    Markup markup;
                    Velocity.evaluate((Context)ctx, (Writer)writer, (String)logTag, (Reader)templateReader);
                    String result = writer.toString();
                    if (this.escapeHtml()) {
                        result = ((Object)Strings.escapeMarkup((String)result)).toString();
                    }
                    if (!this.parseGeneratedMarkup()) {
                        this.replaceComponentTagBody(markupStream, openTag, result);
                        break block11;
                    }
                    try {
                        MarkupParser parser = this.getApplication().getMarkupSettings().getMarkupParserFactory().newMarkupParser(new MarkupResourceStream((IResourceStream)new StringResourceStream((CharSequence)result)));
                        markup = parser.parse();
                    }
                    catch (ResourceStreamNotFoundException e) {
                        throw new RuntimeException("Could not parse resulting markup", e);
                    }
                    markupStream.skipRawMarkup();
                    this.renderAll(new MarkupStream(markup));
                }
                catch (ParseErrorException e) {
                    this.onException((Exception)((Object)e), markupStream, openTag);
                }
                catch (MethodInvocationException e) {
                    this.onException((Exception)((Object)e), markupStream, openTag);
                }
                catch (ResourceNotFoundException e) {
                    this.onException((Exception)((Object)e), markupStream, openTag);
                }
                catch (IOException e) {
                    this.onException(e, markupStream, openTag);
                }
            } else {
                this.replaceComponentTagBody(markupStream, openTag, "");
            }
        }
    }

    protected boolean parseGeneratedMarkup() {
        return false;
    }

    protected boolean throwVelocityExceptions() {
        return false;
    }
}

