/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class IntHashMap<V>
implements Cloneable,
Serializable {
    volatile transient Set<Integer> keySet = null;
    volatile transient Collection<V> values = null;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    transient AtomicInteger modCount = new AtomicInteger(0);
    private transient Set<Entry<V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    public IntHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    void init() {
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(int key) {
        int i = IntHashMap.indexFor(key, this.table.length);
        Entry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(int key) {
        int i = IntHashMap.indexFor(key, this.table.length);
        Entry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    Entry<V> getEntry(int key) {
        int i = IntHashMap.indexFor(key, this.table.length);
        Entry<V> e = this.table[i];
        while (e != null && key != e.key) {
            e = e.next;
        }
        return e;
    }

    public V put(int key, V value) {
        int i = IntHashMap.indexFor(key, this.table.length);
        Entry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.modCount.incrementAndGet();
        this.addEntry(key, value, i);
        return null;
    }

    private void putForCreate(int key, V value) {
        int i = IntHashMap.indexFor(key, this.table.length);
        Entry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(key, value, i);
    }

    void putAllForCreate(IntHashMap<V> m) {
        for (Entry<V> entry : m.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<V>[] newTable) {
        Entry<V>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry<V> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = IntHashMap.indexFor(e.key, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public void putAll(IntHashMap<V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Entry<V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(int key) {
        Entry<V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    Entry<V> removeEntryForKey(int key) {
        Entry<V> prev;
        int i = IntHashMap.indexFor(key, this.table.length);
        Entry<V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (key == e.key) {
                this.modCount.incrementAndGet();
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry<V> removeMapping(Object o) {
        Entry<V> prev;
        if (!(o instanceof Entry)) {
            return null;
        }
        Entry entry = (Entry)o;
        int key = entry.getKey();
        int i = IntHashMap.indexFor(key, this.table.length);
        Entry<V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key && e.equals(entry)) {
                this.modCount.incrementAndGet();
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        this.modCount.incrementAndGet();
        Entry<V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<V>[] arr$ = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry<V> entry;
            Entry<V> e = entry = arr$[i$];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<V>[] tab;
        Entry<V>[] arr$ = tab = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry<V> tabEntry;
            Entry<V> e = tabEntry = arr$[i$];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        IntHashMap result = null;
        try {
            result = (IntHashMap)super.clone();
            result.table = new Entry[this.table.length];
            result.entrySet = null;
            result.modCount.set(0);
            result.size = 0;
            result.init();
            result.putAllForCreate(this);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    void addEntry(int key, V value, int bucketIndex) {
        this.table[bucketIndex] = new Entry<V>(key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int key, V value, int bucketIndex) {
        this.table[bucketIndex] = new Entry<V>(key, value, this.table[bucketIndex]);
        ++this.size;
    }

    Iterator<Integer> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Entry<V>> newEntryIterator() {
        return new EntryIterator();
    }

    public Set<Integer> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<Entry<V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        for (Entry<V> entry : this.entrySet()) {
            s.writeInt(entry.getKey());
            s.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.modCount = new AtomicInteger(0);
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            int key = s.readInt();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return IntHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = IntHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return IntHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return IntHashMap.this.size;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return IntHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IntHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return IntHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Number) {
                return IntHashMap.this.containsKey(((Number)o).intValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Number) {
                return IntHashMap.this.removeEntryForKey(((Number)o).intValue()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public Entry<V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<Integer> {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<H>
    implements Iterator<H> {
        Entry<V> next;
        int expectedModCount;
        int index;
        Entry<V> current;

        HashIterator() {
            this.expectedModCount = IntHashMap.this.modCount.get();
            Entry<V>[] t = IntHashMap.this.table;
            int i = t.length;
            Entry n = null;
            if (IntHashMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<V> nextEntry() {
            if (!IntHashMap.this.modCount.compareAndSet(this.expectedModCount, this.expectedModCount)) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry<V>[] t = IntHashMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (!IntHashMap.this.modCount.compareAndSet(this.expectedModCount, this.expectedModCount)) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            IntHashMap.this.removeEntryForKey(k);
            this.expectedModCount = IntHashMap.this.modCount.get();
        }
    }

    public static class Entry<V> {
        final int key;
        V value;
        Entry<V> next;

        Entry(int k, V v, Entry<V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            V v2;
            V v1;
            int k2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            int k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

