/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.encoding;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.wicket.util.string.Strings;

public class UrlDecoder {
    private final boolean decodePlus;
    public static final UrlDecoder QUERY_INSTANCE = new UrlDecoder(true);
    public static final UrlDecoder PATH_INSTANCE = new UrlDecoder(false);

    private UrlDecoder(boolean decodePlus) {
        this.decodePlus = decodePlus;
    }

    public String decode(String s, Charset enc) {
        return this.decode(s, enc.name());
    }

    public String decode(String s, String enc) {
        if (Strings.isEmpty(s)) {
            return s;
        }
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.length() == 0) {
            throw new RuntimeException(new UnsupportedEncodingException("URLDecoder: empty string enc parameter"));
        }
        byte[] bytes = null;
        block8: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(this.decodePlus ? (char)' ' : '+');
                    ++i;
                    continue block8;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        try {
                            sb.append(new String(bytes, 0, pos, enc));
                            continue block8;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString().replace("\u0000", "NULL");
    }
}

