/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.convert.converter.AbstractNumberConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegerConverter<I extends Number>
extends AbstractNumberConverter<I> {
    private static final long serialVersionUID = 1L;
    private final ConcurrentHashMap<Locale, NumberFormat> numberFormats = new ConcurrentHashMap();

    @Override
    public NumberFormat getNumberFormat(Locale locale) {
        NumberFormat numberFormat = this.numberFormats.get(locale);
        if (numberFormat == null) {
            numberFormat = NumberFormat.getIntegerInstance(locale);
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            NumberFormat tmpNumberFormat = this.numberFormats.putIfAbsent(locale, numberFormat);
            if (tmpNumberFormat != null) {
                numberFormat = tmpNumberFormat;
            }
        }
        return (NumberFormat)numberFormat.clone();
    }
}

