/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMetaCache<T> {
    private volatile Map<ClassLoader, ConcurrentHashMap<String, T>> cache = Collections.emptyMap();

    public T put(Class<?> key, T value) {
        ConcurrentHashMap<String, T> container = this.getClassLoaderCache(key.getClassLoader(), true);
        return container.put(ClassMetaCache.key(key), value);
    }

    public T get(Class<?> key) {
        ConcurrentHashMap<String, T> container = this.getClassLoaderCache(key.getClassLoader(), false);
        if (container == null) {
            return null;
        }
        return container.get(ClassMetaCache.key(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<String, T> getClassLoaderCache(ClassLoader classLoader, boolean create) {
        ConcurrentHashMap<String, Object> container = this.cache.get(classLoader);
        if (container == null) {
            if (!create) {
                return container;
            }
            ClassMetaCache classMetaCache = this;
            synchronized (classMetaCache) {
                container = this.cache.get(classLoader);
                if (container == null) {
                    container = new ConcurrentHashMap();
                    WeakHashMap<ClassLoader, ConcurrentHashMap<String, T>> newCache = new WeakHashMap<ClassLoader, ConcurrentHashMap<String, T>>(this.cache);
                    newCache.put(classLoader, container);
                    this.cache = Collections.unmodifiableMap(newCache);
                }
            }
        }
        return container;
    }

    private static String key(Class<?> clazz) {
        return clazz.getName();
    }
}

