/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.sql.Date;
import java.text.DateFormat;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractConverter;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 1L;

    @Override
    public Date convertToObject(String value, Locale locale) {
        if (value == null || Strings.isEmpty(value)) {
            return null;
        }
        return new Date(((Date)this.parse(this.getDateFormat(locale), value, locale)).getTime());
    }

    @Override
    public String convertToString(Date value, Locale locale) {
        DateFormat dateFormat = this.getDateFormat(locale);
        if (dateFormat != null) {
            return dateFormat.format(value);
        }
        return value.toString();
    }

    public DateFormat getDateFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return DateFormat.getDateInstance(3, locale);
    }

    @Override
    protected Class<Date> getTargetType() {
        return Date.class;
    }
}

