/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import junit.framework.Assert;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.license.ApacheLicenseHeaderTestCase;
import org.apache.wicket.util.license.ILicenseHeaderHandler;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractLicenseHeaderHandler
implements ILicenseHeaderHandler {
    protected static final String LINE_ENDING = System.getProperty("line.separator");
    private String licenseHeader;
    private final List<String> ignoreFiles;

    public AbstractLicenseHeaderHandler(List<String> ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    @Override
    public List<String> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    @Override
    public boolean addLicenseHeader(File file) {
        System.out.println("Not supported yet.");
        return false;
    }

    @Override
    public String getLicenseType(File file) {
        return null;
    }

    protected abstract String getLicenseHeaderFilename();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLicenseHeader() {
        if (Strings.isEmpty(this.licenseHeader)) {
            LineNumberReader lineNumberReader = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                inputStream = ApacheLicenseHeaderTestCase.class.getResourceAsStream(this.getLicenseHeaderFilename());
                inputStreamReader = new InputStreamReader(inputStream);
                lineNumberReader = new LineNumberReader(inputStreamReader);
                StringBuilder header = new StringBuilder();
                String line = lineNumberReader.readLine();
                while (line != null) {
                    header.append(line);
                    header.append(LINE_ENDING);
                    line = lineNumberReader.readLine();
                }
                this.licenseHeader = header.toString().trim();
            }
            catch (Exception e) {
                try {
                    Assert.fail((String)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(lineNumberReader);
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(inputStreamReader);
                    throw throwable;
                }
                IOUtils.closeQuietly(lineNumberReader);
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(inputStreamReader);
            }
            IOUtils.closeQuietly(lineNumberReader);
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(inputStreamReader);
        }
        return this.licenseHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String extractLicenseHeader(File file, int start, int length) {
        block12: {
            header = new StringBuilder();
            lineNumberReader = null;
            try {
                fileReader = new FileReader(file);
                lineNumberReader = new LineNumberReader(fileReader);
                for (i = start; i < length; ++i) {
                    header.append(lineNumberReader.readLine());
                    header.append(AbstractLicenseHeaderHandler.LINE_ENDING);
                }
                ** try [egrp 1[TRYBLOCK] [0 : 68->76)] { 
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                break block12;
            }
            finally {
                try {
                    IOUtils.close(lineNumberReader);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
lbl-1000:
            // 1 sources

            {
                IOUtils.close(lineNumberReader);
            }
lbl15:
            // 1 sources

            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            {
            }
        }
        return header.toString().trim();
    }

    protected void prependLicenseHeader(File file) {
        try {
            String content = new org.apache.wicket.util.file.File(file).readString();
            content = this.getLicenseHeader() + LINE_ENDING + content;
            new org.apache.wicket.util.file.File(file).write(content);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

