/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.io.File;
import java.io.IOException;
import org.apache.wicket.util.file.FileDeleteStrategy;

public class FolderDeleteStrategy
extends FileDeleteStrategy {
    protected FolderDeleteStrategy() {
        super("folder");
    }

    public boolean deleteQuietly(File folder) {
        if (folder == null || folder.isFile()) {
            return false;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteQuietly(file);
                    continue;
                }
                super.deleteQuietly(file);
            }
        }
        return super.deleteQuietly(folder);
    }

    public void delete(File folder) throws IOException {
        if (folder == null || folder.isFile()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                super.delete(file);
            }
        }
    }
}

