/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractConverter;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateConverter
extends AbstractConverter<java.sql.Date> {
    private static final long serialVersionUID = 1L;

    @Override
    public java.sql.Date convertToObject(String value, Locale locale) {
        if (value == null || Strings.isEmpty(value)) {
            return null;
        }
        Date date = this.parseDate(this.getDateFormat(locale), value, locale);
        return new java.sql.Date(date.getTime());
    }

    @Override
    public String convertToString(java.sql.Date value, Locale locale) {
        DateFormat dateFormat = this.getDateFormat(locale);
        if (dateFormat != null) {
            return dateFormat.format(value);
        }
        return value.toString();
    }

    public DateFormat getDateFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (DateFormat)DateFormat.getDateInstance(3, locale).clone();
    }

    @Override
    protected Class<java.sql.Date> getTargetType() {
        return java.sql.Date.class;
    }

    private Date parseDate(Format format, Object value, Locale locale) {
        ParsePosition position = new ParsePosition(0);
        String stringValue = value.toString();
        Date result = (Date)format.parseObject(stringValue, position);
        if (position.getIndex() != stringValue.length()) {
            throw this.newConversionException("Cannot parse '" + value + "' using format " + format, value, locale).setFormat(format);
        }
        return result;
    }
}

