/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.util.time.AbstractTime;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;

public final class TimeOfDay
extends AbstractTime {
    private static final long serialVersionUID = 1L;
    public static final Meridian AM = new Meridian("AM");
    public static final TimeOfDay MIDNIGHT = TimeOfDay.time(12, 0, AM);
    public static final Meridian PM = new Meridian("PM");
    public static final TimeOfDay NOON = TimeOfDay.time(12, 0, PM);

    public static TimeOfDay militaryTime(int hour, int minute, int second) {
        if (hour > 23 || hour < 0) {
            throw new IllegalArgumentException("Hour " + hour + " is not valid");
        }
        if (minute > 59 || minute < 0) {
            throw new IllegalArgumentException("Minute " + minute + " is not valid");
        }
        if (second > 59 || second < 0) {
            throw new IllegalArgumentException("Second " + second + " is not valid");
        }
        return TimeOfDay.valueOf(Duration.hours(hour).add(Duration.minutes(minute)).add(Duration.seconds(second)));
    }

    public static TimeOfDay now() {
        return TimeOfDay.valueOf(Time.now());
    }

    public static TimeOfDay now(Calendar calendar) {
        return TimeOfDay.valueOf(calendar, Time.now());
    }

    public static TimeOfDay time(int hour, int minute, int second, Meridian meridian) {
        if (meridian == PM) {
            if (hour == 12) {
                return TimeOfDay.militaryTime(12, minute, second);
            }
            return TimeOfDay.militaryTime(hour + 12, minute, second);
        }
        if (hour == 12) {
            return TimeOfDay.militaryTime(0, minute, second);
        }
        return TimeOfDay.militaryTime(hour, minute, second);
    }

    public static TimeOfDay time(int hour, int minute, Meridian meridian) {
        return TimeOfDay.time(hour, minute, 0, meridian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOfDay valueOf(Calendar calendar, String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = timeFormat;
        synchronized (simpleDateFormat) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                timeFormat.setCalendar(calendar);
                return new TimeOfDay(timeFormat.parse(time).getTime());
            }
        }
    }

    public static TimeOfDay valueOf(Calendar calendar, Time time) {
        return TimeOfDay.militaryTime(time.getHour(calendar), time.getMinute(calendar), time.getSecond(calendar));
    }

    public static TimeOfDay valueOf(Duration duration) {
        return new TimeOfDay(duration.getMilliseconds());
    }

    public static TimeOfDay valueOf(long time) {
        return new TimeOfDay(time);
    }

    public static TimeOfDay valueOf(String time) throws ParseException {
        return TimeOfDay.valueOf(localtime, time);
    }

    public static TimeOfDay valueOf(Time time) {
        return TimeOfDay.valueOf(AbstractTime.localtime, time);
    }

    private TimeOfDay(long time) {
        super(time);
        if (Duration.valueOf(time).greaterThan(Duration.ONE_DAY)) {
            throw new IllegalArgumentException("Time " + this + " is not a time of day value");
        }
    }

    public int hour() {
        return this.toHours(this.getMilliseconds());
    }

    public int minute() {
        return this.toMinutes(this.getMilliseconds()) % 60;
    }

    public Time next() {
        return this.next(AbstractTime.localtime);
    }

    public Time next(Calendar calendar) {
        Time timeToday = Time.valueOf(calendar, this);
        if (timeToday.before(Time.now())) {
            return Time.valueOf(calendar, this).add(Duration.ONE_DAY);
        }
        return timeToday;
    }

    public int second() {
        return this.toSeconds(this.getMilliseconds()) % 60;
    }

    public String toString() {
        int second = this.second();
        return "" + this.hour() + ":" + this.minute() + (second != 0 ? ":" + second : "");
    }

    private int toHours(long milliseconds) {
        return this.toMinutes(milliseconds) / 60;
    }

    private int toMinutes(long milliseconds) {
        return this.toSeconds(milliseconds) / 60;
    }

    private int toSeconds(long milliseconds) {
        return (int)(milliseconds / 1000L);
    }

    public static final class Meridian
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;

        Meridian(String name) {
            super(name);
        }
    }
}

