/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checks {
    public static void notNull(Object argument, String message) {
        if (argument == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void notEmpty(String argument, String message) {
        if (Strings.isEmpty(argument)) {
            throw new IllegalStateException(message);
        }
    }

    public static <T extends Comparable<T>> void withinRange(T min, T max, T value, String message) {
        Checks.notNull(min, message);
        Checks.notNull(max, message);
        if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
            throw new IllegalStateException(message);
        }
    }

    public static void notNullShort(Object argument, String name) {
        Checks.notNull(argument, name + " may not be null.");
    }

    public static void notEmptyShort(String argument, String name) {
        Checks.notEmpty(argument, name + " may not be null or empty string.");
    }

    public static <T extends Comparable<T>> void withinRangeShort(T min, T max, T value, String name) {
        Checks.withinRange(min, max, value, String.format("%s must have a value within [%s,%s], but was %s", name, min, max, value));
    }
}

