/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    ByteArrayOutputStream out;

    protected Map<Object, Object> getParameters() {
        return null;
    }

    public XSLTResourceStream(IResourceStream xsltResource, IResourceStream xmlResource) {
        try {
            StreamSource xmlSource = new StreamSource(xmlResource.getInputStream());
            StreamSource xsltSource = new StreamSource(xsltResource.getInputStream());
            this.out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(this.out);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            Map<Object, Object> parameters = this.getParameters();
            if (parameters != null) {
                for (Map.Entry<Object, Object> e : parameters.entrySet()) {
                    trans.setParameter(e.getKey().toString(), e.getValue().toString());
                }
            }
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                xmlResource.close();
                xsltResource.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return new ByteArrayInputStream(this.out.toByteArray());
    }

    @Override
    public long length() {
        return this.out.size();
    }

    @Override
    public Time lastModifiedTime() {
        return null;
    }
}

