/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.file.Folder;
import org.apache.wicket.util.file.IResourcePath;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.StringList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path
implements IResourcePath {
    private final List<Folder> folders = new ArrayList<Folder>();

    public Path() {
    }

    public Path(Folder folder) {
        this.add(folder);
    }

    public Path(Folder[] folders) {
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                this.add(folders[i]);
            }
        }
    }

    public void add(Folder folder) {
        if (!folder.exists()) {
            throw new IllegalArgumentException("Folder " + folder + " does not exist");
        }
        this.folders.add(folder);
    }

    @Override
    public void add(String path) {
        this.add(new Folder(path));
    }

    @Override
    public IResourceStream find(Class<?> clazz, String pathname) {
        for (int i = 0; i < this.folders.size(); ++i) {
            Folder folder = this.folders.get(i);
            File file = new File(folder, pathname);
            if (!file.exists()) continue;
            return new FileResourceStream(file);
        }
        return null;
    }

    public List<Folder> getFolders() {
        return this.folders;
    }

    public int size() {
        return this.folders.size();
    }

    public String toString() {
        return "[folders = " + StringList.valueOf(this.folders) + "]";
    }
}

