/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverter
implements IConverter {
    private static final long serialVersionUID = 1L;

    protected Object parse(Format format, Object value, Locale locale) {
        ParsePosition position = new ParsePosition(0);
        String stringValue = value.toString();
        Object result = format.parseObject(stringValue, position);
        if (position.getIndex() != stringValue.length()) {
            throw this.newConversionException("Cannot parse '" + value + "' using format " + format, value, locale).setFormat(format);
        }
        return result;
    }

    protected ConversionException newConversionException(String message, Object value, Locale locale) {
        return new ConversionException(message).setSourceValue(value).setTargetType(this.getTargetType()).setConverter(this).setLocale(locale);
    }

    protected abstract Class<?> getTargetType();

    @Override
    public String convertToString(Object value, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

