/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring;

import junit.framework.TestCase;
import org.apache.wicket.spring.Bean;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.SpringBeanLocator;
import org.apache.wicket.spring.test.ApplicationContextMock;
import org.apache.wicket.spring.test.SpringContextLocatorMock;
import org.apache.wicket.util.lang.WicketObjects;
import org.springframework.context.ApplicationContext;

public class SpringBeanLocatorTest
extends TestCase {
    private ApplicationContextMock ctx;
    private ISpringContextLocator ctxLocator;

    public SpringBeanLocatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.ctx = new ApplicationContextMock();
        this.ctxLocator = new SpringContextLocatorMock((ApplicationContext)this.ctx);
    }

    public void testLookupByClass() {
        Bean bean = new Bean();
        this.ctx.putBean("bean", (Object)bean);
        SpringBeanLocator locator = new SpringBeanLocator(Bean.class, this.ctxLocator);
        SpringBeanLocatorTest.assertTrue((locator.locateProxyTarget() == bean ? 1 : 0) != 0);
    }

    public void testLookupByClassAfterDeserialization() {
        Bean bean = new Bean();
        this.ctx.putBean("bean", (Object)bean);
        SpringBeanLocator locator = (SpringBeanLocator)WicketObjects.cloneObject((Object)new SpringBeanLocator(Bean.class, this.ctxLocator));
        SpringBeanLocatorTest.assertNotNull((Object)locator.locateProxyTarget());
    }

    public void testLookupByClassNotFound() {
        SpringBeanLocator locator = new SpringBeanLocator(Bean.class, this.ctxLocator);
        try {
            locator.locateProxyTarget();
            SpringBeanLocatorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLookupByClassTooManyFound() {
        Bean bean = new Bean();
        this.ctx.putBean("somebean", (Object)bean);
        this.ctx.putBean("somebean2", (Object)bean);
        SpringBeanLocator locator = new SpringBeanLocator(Bean.class, this.ctxLocator);
        try {
            locator.locateProxyTarget();
            SpringBeanLocatorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLookupByName() {
        Bean bean = new Bean();
        this.ctx.putBean("bean", (Object)bean);
        SpringBeanLocator locator = new SpringBeanLocator("bean", Bean.class, this.ctxLocator);
        SpringBeanLocatorTest.assertTrue((locator.locateProxyTarget() == bean ? 1 : 0) != 0);
    }

    public void testLookupByNameAfterDeserialization() {
        Bean bean = new Bean();
        this.ctx.putBean("bean", (Object)bean);
        SpringBeanLocator locator = (SpringBeanLocator)WicketObjects.cloneObject((Object)new SpringBeanLocator("bean", Bean.class, this.ctxLocator));
        SpringBeanLocatorTest.assertNotNull((Object)locator.locateProxyTarget());
    }

    public void testLookupByNameNotFound() {
        SpringBeanLocator locator = new SpringBeanLocator("bean", Bean.class, this.ctxLocator);
        try {
            locator.locateProxyTarget();
            SpringBeanLocatorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testConstructorArguments() {
        try {
            new SpringBeanLocator(null, this.ctxLocator);
            SpringBeanLocatorTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new SpringBeanLocator(Bean.class, null);
            SpringBeanLocatorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testContextNotFound() {
        SpringContextLocatorMock ctxLocator = new SpringContextLocatorMock(null);
        SpringBeanLocator locator = new SpringBeanLocator(Bean.class, (ISpringContextLocator)ctxLocator);
        try {
            locator.locateProxyTarget();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEqualsAndHashcode() {
        SpringBeanLocator a = new SpringBeanLocator("bean", SpringBeanLocator.class, this.ctxLocator);
        SpringBeanLocator aprime = new SpringBeanLocator("bean", SpringBeanLocator.class, this.ctxLocator);
        SpringBeanLocator b = new SpringBeanLocator("bean2", SpringBeanLocator.class, this.ctxLocator);
        SpringBeanLocator c = new SpringBeanLocator("bean", SpringBeanLocatorTest.class, this.ctxLocator);
        SpringBeanLocator d = new SpringBeanLocator(SpringBeanLocator.class, this.ctxLocator);
        SpringBeanLocator dprime = new SpringBeanLocator(SpringBeanLocator.class, this.ctxLocator);
        SpringBeanLocator e = new SpringBeanLocator(SpringBeanLocatorTest.class, this.ctxLocator);
        SpringBeanLocatorTest.assertEquals((Object)a, (Object)aprime);
        SpringBeanLocatorTest.assertEquals((Object)aprime, (Object)a);
        SpringBeanLocatorTest.assertEquals((int)a.hashCode(), (int)aprime.hashCode());
        SpringBeanLocatorTest.assertFalse((boolean)a.equals((Object)b));
        SpringBeanLocatorTest.assertFalse((boolean)a.equals((Object)c));
        SpringBeanLocatorTest.assertFalse((boolean)b.equals((Object)c));
        SpringBeanLocatorTest.assertEquals((Object)d, (Object)dprime);
        SpringBeanLocatorTest.assertEquals((Object)dprime, (Object)d);
        this.ctx.putBean("locator", (Object)a);
        SpringBeanLocatorTest.assertEquals((int)d.hashCode(), (int)dprime.hashCode());
        SpringBeanLocatorTest.assertFalse((boolean)a.equals((Object)d));
        SpringBeanLocatorTest.assertFalse((boolean)d.equals((Object)e));
        SpringBeanLocatorTest.assertFalse((boolean)a.equals((Object)this.ctxLocator));
    }
}

